/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.processing.basinlid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.Petrolpark;
import com.petrolpark.compat.create.CreateRecipeTypes;
import com.petrolpark.compat.create.core.recipe.AdvancedProcessingRecipeParams;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.HolderSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.biome.Biome;

public class LiddedBasinRecipe
extends BasinRecipe {
    public static final MapCodec<LiddedBasinRecipe> CODEC = ProcessingRecipe.codec(LiddedBasinRecipe::new, Params.CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, LiddedBasinRecipe> STREAM_CODEC = ProcessingRecipe.streamCodec(LiddedBasinRecipe::new, Params.STREAM_CODEC);
    protected final Optional<HolderSet<Biome>> allowedBiomes;
    protected final Optional<ResourceLocation> firstTimeLuckyKey;
    public final boolean bubbles;

    public static final Builder builder() {
        return new Builder(Petrolpark.asResource("dont_register_me"));
    }

    protected static final LiddedBasinRecipe create(Params params) {
        return new LiddedBasinRecipe(params);
    }

    protected LiddedBasinRecipe(ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)CreateRecipeTypes.LIDDED_BASIN, params);
        if (!(params instanceof Params)) {
            throw new IllegalStateException("Not Lidded Basin Recipe Params");
        }
        Params properParams = (Params)params;
        this.allowedBiomes = properParams.allowedBiomes();
        this.firstTimeLuckyKey = properParams.firstTimeLuckyKey();
        this.bubbles = properParams.bubbles();
    }

    public boolean bubbles() {
        return this.bubbles;
    }

    public List<String> validate() {
        List errors = super.validate();
        if (this.processingDuration <= 0) {
            errors.add("Recipe does not specify a positive duration.");
        }
        return errors;
    }

    public static class Builder
    extends ProcessingRecipeBuilder<ProcessingRecipeParams, LiddedBasinRecipe, Builder> {
        public Builder(ResourceLocation recipeId) {
            super(LiddedBasinRecipe::new, recipeId);
        }

        protected Params createParams() {
            return new Params();
        }

        public Builder self() {
            return this;
        }

        public Builder withBubbles() {
            ((Params)this.params).bubbles = true;
            return this.self();
        }
    }

    protected static class Params
    extends AdvancedProcessingRecipeParams {
        public static final MapCodec<ProcessingRecipeParams> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Params.codec(Params::new).forGetter(Function.identity()), (App)Codec.BOOL.optionalFieldOf("bubbles", (Object)true).forGetter(Params::bubbles)).apply((Applicative)instance, (params, bubbles) -> {
            params.bubbles = bubbles;
            return params;
        })).flatXmap(DataResult::success, params -> {
            DataResult dataResult;
            if (params instanceof Params) {
                Params properParams = (Params)((Object)params);
                dataResult = DataResult.success((Object)((Object)properParams));
            } else {
                dataResult = DataResult.error(() -> "Not Lidden Basin Recipe Params");
            }
            return dataResult;
        });
        public static final StreamCodec<RegistryFriendlyByteBuf, ProcessingRecipeParams> STREAM_CODEC = Params.streamCodec(Params::new);
        protected boolean bubbles;

        protected Params() {
        }

        public final boolean bubbles() {
            return this.bubbles;
        }

        @Override
        protected void encode(RegistryFriendlyByteBuf buffer) {
            super.encode(buffer);
            ByteBufCodecs.BOOL.encode((Object)buffer, (Object)this.bubbles);
        }

        @Override
        protected void decode(RegistryFriendlyByteBuf buffer) {
            super.decode(buffer);
            this.bubbles = (Boolean)ByteBufCodecs.BOOL.decode((Object)buffer);
        }
    }

    public static class Serializer
    implements RecipeSerializer<LiddedBasinRecipe> {
        public MapCodec<LiddedBasinRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, LiddedBasinRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

