/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.processing.extrusion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.compat.create.common.processing.extrusion.ExtrusionRecipe;
import com.petrolpark.util.AdvancementHelper;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ExtrudeCriterionTrigger
extends SimpleCriterionTrigger<Instance> {
    public void trigger(ServerPlayer player, RecipeHolder<ExtrusionRecipe> recipeHolder, BlockState inputState, BlockState outputState) {
        this.trigger(player, instance -> instance.matches(recipeHolder, inputState, outputState));
    }

    public Consumer<ServerPlayer> trigger(RecipeHolder<ExtrusionRecipe> recipeHolder, BlockState inputState, BlockState outputState) {
        return player -> this.trigger(recipeHolder, inputState, outputState);
    }

    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<ResourceLocation> recipeId, Optional<HolderSet<Block>> inputBlock, Optional<StatePropertiesPredicate> inputState, Optional<HolderSet<Block>> outputBlock, Optional<StatePropertiesPredicate> outputState) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("owner").forGetter(Instance::player), (App)ResourceLocation.CODEC.optionalFieldOf("recipe").forGetter(Instance::recipeId), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).optionalFieldOf("input_block").forGetter(Instance::inputBlock), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("input_state").forGetter(Instance::inputState), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).optionalFieldOf("outut_block").forGetter(Instance::inputBlock), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("output_state").forGetter(Instance::inputState)).apply((Applicative)instance, Instance::new));

        boolean matches(RecipeHolder<ExtrusionRecipe> recipeHolder, BlockState inputState, BlockState outputState) {
            return AdvancementHelper.test(this.recipeId(), recipeHolder.id()) && AdvancementHelper.testBlocks(this.inputBlock(), inputState) && AdvancementHelper.testState(this.inputState(), inputState) && AdvancementHelper.testBlocks(this.outputBlock(), outputState) && AdvancementHelper.testState(this.outputState(), outputState);
        }
    }
}

