/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.processing.extrusion;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.compat.create.CreateCriterionTriggers;
import com.petrolpark.compat.create.common.processing.extrusion.ExtrudeCriterionTrigger;
import com.petrolpark.compat.create.common.processing.extrusion.ExtrudedBlockModel;
import com.petrolpark.compat.create.common.processing.extrusion.ExtrusionDieBlock;
import com.petrolpark.compat.create.common.processing.extrusion.ExtrusionRecipe;
import com.petrolpark.compat.create.core.block.entity.behaviour.AdvancementBehaviour;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import java.util.Optional;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.SuperBufferFactory;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ExtrusionMovementBehaviour
implements MovementBehaviour {
    public static final String EXTRUDING_TAG_KEY = "Extruding";
    public static final String EXTRUDED_TAG_KEY = "Extruded";
    public static final String EXTRUSION_DIRECTION_TAG_KEY = "ExtrusionDirection";
    public static final String EXTRUSION_DIE_POS_TAG_KEY = "ExtrusionDiePosTagKey";
    public static final String EXTRUDED_BLOCK_STATE_TAG_KEY = "ExtrudedBlockState";
    private final RecipeHolder<ExtrusionRecipe> extrusionRecipeHolder;

    public ExtrusionMovementBehaviour(RecipeHolder<ExtrusionRecipe> extrusionRecipeHolder) {
        this.extrusionRecipeHolder = extrusionRecipeHolder;
    }

    public void onSpeedChanged(MovementContext context, Vec3 oldMotion, Vec3 motion) {
        CompoundTag data = context.data;
        if (data.getBoolean(EXTRUDING_TAG_KEY)) {
            Direction direction = ExtrusionMovementBehaviour.getDirection(context);
            if (!(motion.equals((Object)Vec3.ZERO) || VecHelper.isVecPointingTowards((Vec3)motion, (Direction)direction) || VecHelper.isVecPointingTowards((Vec3)motion, (Direction)direction.getOpposite()))) {
                this.abandonExtrusion(context);
            }
        }
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        BlockState dieState = context.world.getBlockState(pos);
        CompoundTag data = context.data;
        if (dieState.getBlock() instanceof ExtrusionDieBlock && !data.getBoolean(EXTRUDING_TAG_KEY) && !data.getBoolean(EXTRUDED_TAG_KEY)) {
            Direction.Axis axis = (Direction.Axis)dieState.getValue((Property)BlockStateProperties.AXIS);
            for (Direction.AxisDirection axisDirection : Direction.AxisDirection.values()) {
                Direction direction = Direction.get((Direction.AxisDirection)axisDirection, (Direction.Axis)axis);
                BlockState state = ((ExtrusionRecipe)this.extrusionRecipeHolder.value()).extrude(context.state, direction);
                if (!VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)direction) || state.isAir()) continue;
                data.putBoolean(EXTRUDING_TAG_KEY, true);
                data.putInt(EXTRUSION_DIRECTION_TAG_KEY, direction.ordinal());
                data.put(EXTRUSION_DIE_POS_TAG_KEY, NbtUtils.writeBlockPos((BlockPos)pos));
                data.put(EXTRUDED_BLOCK_STATE_TAG_KEY, (Tag)NbtUtils.writeBlockState((BlockState)state));
                break;
            }
        } else if (data.getBoolean(EXTRUDING_TAG_KEY)) {
            OrientedContraptionEntity oce;
            Optional diePosOp = NbtUtils.readBlockPos((CompoundTag)data, (String)EXTRUSION_DIE_POS_TAG_KEY);
            if (diePosOp.isEmpty()) {
                return;
            }
            BlockPos diePos = (BlockPos)diePosOp.get();
            Direction direction = ExtrusionMovementBehaviour.getDirection(context);
            AbstractContraptionEntity axisDirection = context.contraption.entity;
            if (axisDirection instanceof OrientedContraptionEntity && (oce = (OrientedContraptionEntity)axisDirection).getInitialYaw() != oce.yaw) {
                direction = direction.getOpposite();
            }
            if (pos.equals((Object)diePos.relative(direction))) {
                AdvancementBehaviour advancementBehaviour;
                BlockState extrudedBlockState = ExtrusionMovementBehaviour.getExtrudedBlockState(context);
                context.contraption.getBlocks().put(context.localPos, new StructureTemplate.StructureBlockInfo(context.localPos, extrudedBlockState, null));
                if (!context.world.isClientSide() && (advancementBehaviour = (AdvancementBehaviour)BlockEntityBehaviour.get((BlockGetter)context.world, (BlockPos)diePos, AdvancementBehaviour.TYPE)) != null) {
                    advancementBehaviour.award(((ExtrudeCriterionTrigger)((Object)CreateCriterionTriggers.EXTRUSION.get())).trigger(this.extrusionRecipeHolder, context.state, extrudedBlockState));
                }
                data.putBoolean(EXTRUDED_TAG_KEY, true);
            }
            this.abandonExtrusion(context);
        }
    }

    public void tick(MovementContext context) {
        if (!context.world.isClientSide() || !context.data.getBoolean(EXTRUDING_TAG_KEY)) {
            return;
        }
        Direction direction = ExtrusionMovementBehaviour.getDirection(context);
        if (!VecHelper.isVecPointingTowards((Vec3)context.motion, (Direction)direction)) {
            return;
        }
        Optional diePosOp = NbtUtils.readBlockPos((CompoundTag)context.data, (String)EXTRUSION_DIE_POS_TAG_KEY);
        if (diePosOp.isEmpty()) {
            return;
        }
        BlockPos diePos = (BlockPos)diePosOp.get();
        Vec3 step = new Vec3(direction.step());
        double speed = context.motion.dot(step);
        BlockState extrudedState = ExtrusionMovementBehaviour.getExtrudedBlockState(context);
        for (Direction face : Iterate.directions) {
            if (face.getAxis() == direction.getAxis()) continue;
            Vec3 loc = VecHelper.getCenterOf((Vec3i)diePos).add(new Vec3(face.step()).scale(0.5)).add(face.getAxis() == Direction.Axis.X ? 0.0 : (double)(-0.5f + context.world.getRandom().nextFloat()), face.getAxis() == Direction.Axis.Y ? 0.0 : (double)(-0.5f + context.world.getRandom().nextFloat()), face.getAxis() == Direction.Axis.Z ? 0.0 : (double)(-0.5f + context.world.getRandom().nextFloat()));
            Vec3 velocity = step.scale(speed).add(new Vec3(face.step()).scale((double)0.1f));
            context.world.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, extrudedState), loc.x(), loc.y(), loc.z(), velocity.x(), velocity.y(), velocity.z());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        CompoundTag data = context.data;
        if (!data.getBoolean(EXTRUDING_TAG_KEY) && !data.getBoolean(EXTRUDED_TAG_KEY)) {
            return;
        }
        PoseStack ms = matrices.getViewProjection();
        PoseStack modelTransform = matrices.getModel();
        VertexConsumer vbSolid = buffer.getBuffer(RenderType.solid());
        Direction direction = ExtrusionMovementBehaviour.getDirection(context);
        float progress = 0.0f;
        if (data.getBoolean(EXTRUDED_TAG_KEY)) {
            progress = 0.0f;
        } else {
            OrientedContraptionEntity oce;
            Optional diePosOp = NbtUtils.readBlockPos((CompoundTag)data, (String)EXTRUSION_DIE_POS_TAG_KEY);
            if (diePosOp.isEmpty()) {
                return;
            }
            BlockPos diePos = (BlockPos)diePosOp.get();
            Vec3 displacement = context.position.subtract(Vec3.atLowerCornerOf((Vec3i)diePos));
            progress = (float)direction.getAxis().choose(displacement.x(), displacement.y(), displacement.z());
            boolean invertProgess = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE;
            AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
            if (abstractContraptionEntity instanceof OrientedContraptionEntity && oce.yaw != (oce = (OrientedContraptionEntity)abstractContraptionEntity).getInitialYaw()) {
                boolean bl = invertProgess = !invertProgess;
            }
            if (invertProgess) {
                progress = 1.0f - progress;
            }
        }
        ms.pushPose();
        BlockState extrudedState = ExtrusionMovementBehaviour.getExtrudedBlockState(context);
        ExtrudedBlockModel model = new ExtrudedBlockModel(extrudedState, direction, progress);
        SuperByteBuffer extrudedBlockBuffer = SuperBufferFactory.getInstance().createForBlock((BakedModel)model, Blocks.AIR.defaultBlockState());
        if (modelTransform != null) {
            extrudedBlockBuffer.transform(modelTransform);
        }
        extrudedBlockBuffer.useLevelLight((BlockAndTintGetter)context.world, matrices.getWorld()).renderInto(ms, vbSolid);
        ms.popPose();
    }

    private void abandonExtrusion(MovementContext context) {
        CompoundTag data = context.data;
        data.putBoolean(EXTRUDING_TAG_KEY, false);
        data.remove(EXTRUSION_DIE_POS_TAG_KEY);
        data.remove(EXTRUSION_DIRECTION_TAG_KEY);
    }

    private static Direction getDirection(MovementContext context) {
        return Direction.values()[context.data.getInt(EXTRUSION_DIRECTION_TAG_KEY)];
    }

    private static BlockState getExtrudedBlockState(MovementContext context) {
        if (!context.data.contains(EXTRUDED_BLOCK_STATE_TAG_KEY)) {
            return Blocks.AIR.defaultBlockState();
        }
        return NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)context.data.getCompound(EXTRUDED_BLOCK_STATE_TAG_KEY));
    }
}

