/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.processing.mandrel;

import com.petrolpark.compat.create.CreateBlockEntityTypes;
import com.petrolpark.compat.create.common.processing.mandrel.MandrelBlockEntity;
import com.petrolpark.compat.create.core.CreateShapes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.Nonnull;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class MandrelBlock
extends HorizontalKineticBlock
implements IBE<MandrelBlockEntity> {
    public static final VoxelShaper SHAPE = CreateShapes.shape(0.0, 0.0, 0.0, 16.0, 5.0, 16.0).add(0.0, 5.0, 12.0, 16.0, 16.0, 16.0).add(5.0, 5.0, 1.0, 11.0, 11.0, 12.0).forHorizontal(Direction.NORTH);

    public MandrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE.get((Direction)state.getValue(HORIZONTAL_FACING));
    }

    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        if (!stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide()) {
            return ItemInteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, mandrel -> {
            int slot;
            boolean emptyOutput = true;
            ItemStackHandler inv = mandrel.outputInv;
            for (slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (!stackInSlot.isEmpty()) {
                    emptyOutput = false;
                }
                player.getInventory().placeItemBackInInventory(stackInSlot);
                inv.setStackInSlot(slot, ItemStack.EMPTY);
            }
            if (emptyOutput) {
                inv = mandrel.inputInv;
                for (slot = 0; slot < inv.getSlots(); ++slot) {
                    player.getInventory().placeItemBackInInventory(inv.getStackInSlot(slot));
                    inv.setStackInSlot(slot, ItemStack.EMPTY);
                }
            }
            mandrel.setChanged();
            mandrel.sendData();
        });
        return ItemInteractionResult.SUCCESS;
    }

    public void updateEntityAfterFallOn(@Nonnull BlockGetter worldIn, @Nonnull Entity entityIn) {
        super.updateEntityAfterFallOn(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        if (!entityIn.isAlive()) {
            return;
        }
        MandrelBlockEntity mandrel = null;
        for (BlockPos pos : Iterate.hereAndBelow((BlockPos)entityIn.blockPosition())) {
            if (mandrel != null) continue;
            mandrel = (MandrelBlockEntity)this.getBlockEntity(worldIn, pos);
        }
        if (mandrel == null) {
            return;
        }
        IItemHandler capability = (IItemHandler)entityIn.level().getCapability(Capabilities.ItemHandler.BLOCK, mandrel.getBlockPos(), (Object)Direction.UP);
        if (capability == null) {
            return;
        }
        ItemStack remainder = capability.insertItem(0, itemEntity.getItem(), false);
        if (remainder.isEmpty()) {
            itemEntity.discard();
        }
        if (remainder.getCount() < itemEntity.getItem().getCount()) {
            itemEntity.setItem(remainder);
        }
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.getValue(HORIZONTAL_FACING)).getOpposite();
    }

    public Class<MandrelBlockEntity> getBlockEntityClass() {
        return MandrelBlockEntity.class;
    }

    public BlockEntityType<? extends MandrelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CreateBlockEntityTypes.MANDREL.get();
    }
}

