/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.block.multi;

import com.petrolpark.compat.create.core.block.multi.IMulti;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class MultiAssembler<M extends IMulti<? super M>> {
    public abstract Conversion canConvert(BlockState var1, Level var2, BlockPos var3, Direction var4);

    public abstract BlockState convert(BlockState var1, Level var2, BlockPos var3, Conversion var4);

    protected static enum Results implements Conversion
    {
        FAILURE(true),
        INSIDE(false);

        public final boolean failure;

        private Results(boolean failure) {
            this.failure = failure;
        }

        @Override
        public boolean cannot() {
            return this.failure;
        }

        @Override
        public boolean isInside() {
            return !this.failure;
        }

        @Override
        public Optional<Direction> optionalSide() {
            return Optional.empty();
        }
    }

    public static class SideConversionResult
    implements Conversion {
        protected static final EnumMap<Direction, SideConversionResult> VALUES = new EnumMap(Direction.class);
        public final Optional<Direction> face;

        protected SideConversionResult(Direction face) {
            this.face = Optional.of(face);
        }

        @Override
        public boolean cannot() {
            return false;
        }

        @Override
        public boolean isInside() {
            return false;
        }

        @Override
        public Optional<Direction> optionalSide() {
            return this.face;
        }
    }

    public static interface Conversion {
        public boolean cannot();

        public boolean isInside();

        public Optional<Direction> optionalSide();

        public static Conversion impossible() {
            return Results.FAILURE;
        }

        public static Conversion inside() {
            return Results.INSIDE;
        }

        public static Conversion side(Direction face) {
            return SideConversionResult.VALUES.computeIfAbsent(face, SideConversionResult::new);
        }
    }
}

