/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.recipe.firsttimelucky;

import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.create.CreateAttachmentTypes;
import com.petrolpark.compat.create.core.recipe.firsttimelucky.FTLRecipesBehaviour;
import com.petrolpark.core.data.ResourceLocationSet;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@RequiresCreate
public interface IFTLProcessingRecipe<T extends ProcessingRecipe<?, ?>> {
    public T getAsRecipe();

    public Optional<ResourceLocation> getFirstTimeLuckyKey();

    default public List<ItemStack> rollLuckyResults(Player player, RandomSource random) {
        T recipe = this.getAsRecipe();
        Optional<ResourceLocation> key = this.getFirstTimeLuckyKey();
        if (key.isEmpty() || player == null) {
            return recipe.rollResults(random);
        }
        ResourceLocationSet plfr = (ResourceLocationSet)player.getData(CreateAttachmentTypes.FTL_RECIPES);
        if (plfr.add(key.get())) {
            return recipe.getRollableResults().stream().map(ProcessingOutput::getStack).toList();
        }
        return recipe.rollResults(random);
    }

    default public List<ItemStack> rollLuckyResults(SmartBlockEntity blockEntity, RandomSource random) {
        FTLRecipesBehaviour behaviour = (FTLRecipesBehaviour)blockEntity.getBehaviour(FTLRecipesBehaviour.TYPE);
        if (behaviour != null) {
            return this.rollLuckyResults(behaviour.getPlayer(), random);
        }
        return this.getAsRecipe().rollResults(random);
    }
}

