/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.tube;

import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.create.core.tube.ITubeBlock;
import com.petrolpark.util.BlockFace;
import com.petrolpark.util.ClampedCubicSpline;
import com.petrolpark.util.MathsHelper;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecs;
import net.createmod.catnip.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@RequiresCreate
public class TubeSpline
extends ClampedCubicSpline {
    public static final double MAX_LENGTH = 32.0;
    public static final double MAX_VOLUME = 256.0;
    public static final int MAX_CONTROL_POINTS = 16;
    public final BlockFace start;
    public final BlockFace end;
    public final double maxAngle;
    public final double segmentRadius;
    protected boolean tooSharp;
    protected Set<BlockPos> blockedPositions;
    protected TubePlacementResult result;

    public TubeSpline(BlockFace start, BlockFace end, double maxAngle, double segmentLength, double segmentRadius) {
        this(start, end, Collections.emptyList(), maxAngle, segmentLength, segmentRadius);
    }

    public TubeSpline(BlockFace start, BlockFace end, List<Vec3> middleControlPoints, double maxAngle, double segmentLength, double segmentRadius) {
        super(start.getCenter(), end.getCenter(), new Vec3(start.getFace().step()), new Vec3(end.getFace().getOpposite().step()), segmentLength);
        this.start = start;
        this.end = end;
        this.maxAngle = maxAngle;
        this.segmentRadius = segmentRadius;
        this.controlPoints.addAll(1, middleControlPoints);
        this.recalculate();
    }

    @Override
    public void recalculate() {
        this.blockedPositions = new HashSet<BlockPos>();
        super.recalculate();
        this.tooSharp = false;
        for (int i = 0; i < this.tangents.size() - 1; ++i) {
            Vec3 t2;
            Vec3 t1 = (Vec3)this.tangents.get(i);
            double dot = t1.dot(t2 = (Vec3)this.tangents.get(i + 1)) / (t1.length() * t2.length());
            double angle = Math.acos(Mth.clamp((double)dot, (double)-1.0, (double)1.0));
            if (!(angle > this.maxAngle)) continue;
            this.tooSharp = true;
            break;
        }
    }

    @Override
    protected void forEachSegment(int index, Vec3 point, Vec3 tangent) {
        BlockPos containing = BlockPos.containing((Position)point);
        if (point.subtract(Vec3.atCenterOf((Vec3i)containing)).lengthSqr() < this.segmentRadius && !containing.equals((Object)this.start.getPos()) && !containing.equals((Object)this.end.getPos())) {
            this.blockedPositions.add(containing);
        }
    }

    public List<Vec3> getMiddleControlPoints() {
        return this.controlPoints.subList(1, this.controlPoints.size() - 1);
    }

    public Set<BlockPos> getBlockedPositions() {
        return this.blockedPositions;
    }

    @Override
    public AABB getOccupiedVolume() {
        return super.getOccupiedVolume().inflate(this.segmentRadius);
    }

    public Provider getProvider() {
        return new Provider(this.start, this.end, this.getMiddleControlPoints());
    }

    public TubePlacementResult getResult() {
        return this.result;
    }

    public void validate(Level level, Player player, Item requiredItem, ITubeBlock block) {
        this.result = TubePlacementResult.SUCCESS;
        BlockState startState = level.getBlockState(this.start.getPos());
        BlockState endState = level.getBlockState(this.end.getPos());
        if (startState.getBlock() != block || endState.getBlock() != block) {
            this.result = TubePlacementResult.WRONG_BLOCK;
            return;
        }
        if (block.getTubeConnectingFace(level, this.start.getPos(), startState) != this.start.getFace() || block.getTubeConnectingFace(level, this.end.getPos(), endState) != this.end.getFace()) {
            this.result = TubePlacementResult.WRONG_FACE;
        } else if (this.controlPoints.size() > 16) {
            this.result = TubePlacementResult.TOO_MANY_POINTS;
        } else if (this.totalLength >= 32.0) {
            this.result = TubePlacementResult.TOO_LONG;
        } else if (this.totalLength <= 1.0 || this.start.equals(this.end)) {
            this.result = TubePlacementResult.TOO_SHORT;
        } else if (MathsHelper.volume(this.occupiedVolume) > 256.0) {
            this.result = TubePlacementResult.TOO_BIG;
        } else if (this.tooSharp) {
            this.result = TubePlacementResult.TOO_SHARP;
        } else if (!this.checkCanAfford(player, requiredItem, block)) {
            this.result = TubePlacementResult.TOO_POOR;
        } else {
            int i = 1;
            for (Vec3 controlPoint : this.controlPoints) {
                for (int j = i; j < this.controlPoints.size(); ++j) {
                    if (!(controlPoint.distanceToSqr((Vec3)this.controlPoints.get(j)) < this.segmentLength * this.segmentLength)) continue;
                    this.result = TubePlacementResult.POINTS_TOO_CLOSE;
                    return;
                }
                ++i;
            }
            this.checkBlocked(level, p -> {});
        }
    }

    public boolean checkBlocked(Level level, Consumer<BlockPos> forEachObstructingBlock) {
        boolean blocked = false;
        for (BlockPos pos : this.blockedPositions) {
            BlockState state;
            if (pos.equals((Object)this.start.getPos()) || pos.equals((Object)this.end.getPos()) || (state = level.getBlockState(pos)).canBeReplaced()) continue;
            forEachObstructingBlock.accept(pos);
            blocked = true;
        }
        if (blocked && (this.result == null || this.result.ordinal() > TubePlacementResult.BLOCKED.ordinal())) {
            this.result = TubePlacementResult.BLOCKED;
        }
        return blocked;
    }

    public boolean checkCanAfford(Player player, Item requiredItem, ITubeBlock block) {
        boolean canAfford;
        boolean bl = canAfford = player.getAbilities().instabuild || player.getInventory().countItem(requiredItem) >= block.getItemsForTubeLength(this.getLength());
        if (!(canAfford || this.result != null && this.result.ordinal() <= TubePlacementResult.TOO_POOR.ordinal())) {
            this.result = TubePlacementResult.TOO_POOR;
        }
        return canAfford;
    }

    public record Provider(BlockFace start, BlockFace end, List<Vec3> middleControlPoints) {
        public static final StreamCodec<ByteBuf, Provider> STREAM_CODEC = StreamCodec.composite(BlockFace.STREAM_CODEC, Provider::start, BlockFace.STREAM_CODEC, Provider::end, (StreamCodec)CatnipStreamCodecs.VEC3.apply(ByteBufCodecs.list()), Provider::middleControlPoints, Provider::new);

        public TubeSpline provide(double maxAngle, double segmentLength, double segmentRadius) {
            return new TubeSpline(this.start, this.end, this.middleControlPoints, maxAngle, segmentLength, segmentRadius);
        }
    }

    public static enum TubePlacementResult {
        WRONG_BLOCK,
        WRONG_FACE,
        TOO_MANY_POINTS,
        TOO_LONG,
        TOO_SHORT,
        TOO_BIG,
        TOO_SHARP,
        TOO_POOR,
        POINTS_TOO_CLOSE,
        BLOCKED,
        SUCCESS(true);

        public final boolean success;

        private TubePlacementResult() {
            this(false);
        }

        private TubePlacementResult(boolean success) {
            this.success = success;
        }

        public Component translate(ItemStack stack) {
            return Component.translatable((String)("petrolpark.tube.result." + Lang.asId((String)this.name())), (Object[])new Object[]{stack.getHoverName()}).withStyle(this.success ? ChatFormatting.GREEN : ChatFormatting.RED);
        }
    }
}

