/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.curios;

import com.petrolpark.Petrolpark;
import com.petrolpark.compat.Mods;
import com.petrolpark.compat.curios.CuriosSetup;
import com.petrolpark.compat.curios.renderer.CuriosRenderers;
import com.petrolpark.core.badge.BadgeItem;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class Curios {
    public static Optional<Map<String, ICurioStacksHandler>> getCuriosMap(LivingEntity entity) {
        return Optional.ofNullable((ICuriosItemHandler)entity.getCapability(CuriosCapability.INVENTORY)).map(ICuriosItemHandler::getCurios);
    }

    public static void ctor(IEventBus modEventBus, IEventBus forgeEventBus) {
        Mods.CREATE.executeIfInstalled(() -> () -> GogglesItem.addIsWearingPredicate(Curios.wearingCurioPredicate(stack -> CuriosSetup.ENGINEERS_GOGGLES.stream().anyMatch(b -> ((Item)b.get().get()).equals(stack.getItem())), "head")));
        modEventBus.addListener(Curios::onClientSetup);
        CuriosApi.registerCurioPredicate((ResourceLocation)Petrolpark.asResource("badge"), sr -> sr.stack().getItem() instanceof BadgeItem);
    }

    public static <E extends LivingEntity> Predicate<E> wearingCurioPredicate(Predicate<ItemStack> curioPredicate, String slotId) {
        return le -> Curios.getCuriosMap(le).map(m -> (ICurioStacksHandler)m.get(slotId)).map(sh -> {
            for (int slot = 0; slot < sh.getSlots(); ++slot) {
                if (!curioPredicate.test(sh.getStacks().getStackInSlot(slot))) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        CuriosRenderers.register();
    }
}

