/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.config;

import com.petrolpark.Petrolpark;
import com.petrolpark.RequiresCreate;
import com.petrolpark.config.PetrolparkServerConfig;
import com.simibubi.create.api.stress.BlockStressValues;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import javax.annotation.Nonnull;
import net.createmod.catnip.config.ConfigBase;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

@RequiresCreate
public class PetrolparkStressConfig
extends ConfigBase {
    private static final Object2DoubleMap<ResourceLocation> DEFAULT_IMPACTS = new Object2DoubleOpenHashMap();
    private static final Object2DoubleMap<ResourceLocation> DEFAULT_CAPACITIES = new Object2DoubleOpenHashMap();
    protected final Map<ResourceLocation, ModConfigSpec.ConfigValue<Double>> capacities = new HashMap<ResourceLocation, ModConfigSpec.ConfigValue<Double>>();
    protected final Map<ResourceLocation, ModConfigSpec.ConfigValue<Double>> impacts = new HashMap<ResourceLocation, ModConfigSpec.ConfigValue<Double>>();

    public void registerAll(@Nonnull ModConfigSpec.Builder builder) {
        builder.comment(new String[]{".", Comments.su, Comments.impact}).push("impact");
        DEFAULT_IMPACTS.forEach((id, value) -> this.impacts.put((ResourceLocation)id, (ModConfigSpec.ConfigValue<Double>)builder.define(id.getPath(), value)));
        builder.pop();
        builder.comment(new String[]{".", Comments.su, Comments.capacity}).push("capacity");
        DEFAULT_CAPACITIES.forEach((id, value) -> this.capacities.put((ResourceLocation)id, (ModConfigSpec.ConfigValue<Double>)builder.define(id.getPath(), value)));
        builder.pop();
    }

    public String getName() {
        return "stressValues";
    }

    @Nullable
    public DoubleSupplier getImpact(Block block) {
        ResourceLocation id = RegisteredObjectsHelper.getKeyOrThrow((Block)block);
        ModConfigSpec.ConfigValue<Double> value = this.impacts.get(id);
        return value == null ? null : () -> value.get();
    }

    @Nullable
    public DoubleSupplier getCapacity(Block block) {
        ResourceLocation id = RegisteredObjectsHelper.getKeyOrThrow((Block)block);
        ModConfigSpec.ConfigValue<Double> value = this.capacities.get(id);
        return value == null ? null : () -> value.get();
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setNoImpact() {
        return PetrolparkStressConfig.setImpact(0.0);
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setImpact(double value) {
        return builder -> {
            PetrolparkStressConfig.assertFromPetrolparkLibrary(builder);
            ResourceLocation id = Petrolpark.asResource(builder.getName());
            DEFAULT_IMPACTS.put((Object)id, value);
            return builder;
        };
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setCapacity(double value) {
        return builder -> {
            PetrolparkStressConfig.assertFromPetrolparkLibrary(builder);
            ResourceLocation id = Petrolpark.asResource(builder.getName());
            DEFAULT_CAPACITIES.put((Object)id, value);
            return builder;
        };
    }

    private static void assertFromPetrolparkLibrary(BlockBuilder<?, ?> builder) {
        if (!builder.getOwner().getModid().equals("petrolpark")) {
            throw new IllegalStateException("Non-Petrolpark blocks cannot be added to Create's config.");
        }
    }

    @SubscribeEvent
    public static final void onAddAdditionalConfig(PetrolparkServerConfig.AdditionalEvent event) {
        PetrolparkStressConfig stress = event.nested(0, PetrolparkStressConfig::new, new String[0]);
        BlockStressValues.CAPACITIES.registerProvider(stress::getCapacity);
        BlockStressValues.IMPACTS.registerProvider(stress::getImpact);
    }

    private static class Comments {
        static String su = "[in Stress Units]";
        static String impact = "Individual coefficients of stress impact of kinetic blocks.";
        static String capacity = "Individual stress capacities of kinetic blocks.";

        private Comments() {
        }
    }
}

