/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.actionrecord;

import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;

public sealed interface ActionRecordEntryResult {
    public static final ActionRecordEntryResult SILENT_IGNORE = new SilentIgnore();

    public static ActionRecordEntryResult enter(Component name) {
        return new Logged.Simple(name);
    }

    public static ActionRecordEntryResult enter(Component simpleName, Component advancedName) {
        if (advancedName == null) {
            return ActionRecordEntryResult.enter(simpleName);
        }
        return new Logged.Advanced(simpleName, advancedName);
    }

    public static ActionRecordEntryResult unsupported(CustomPacketPayload.Type<?> payloadType) {
        return new Logged.UnsupportedPayloadType(payloadType.id());
    }

    public static ActionRecordEntryResult unsupported(PacketType<?> packetType) {
        return new Logged.UnsupportedPayloadType(packetType.id());
    }

    public static non-sealed interface Logged
    extends ActionRecordEntryResult {
        public Component name(TooltipFlag var1);

        public record UnsupportedPayloadType(ResourceLocation id) implements Logged
        {
            @Override
            public Component name(TooltipFlag tooltipFlag) {
                return tooltipFlag.isAdvanced() ? Component.translatable((String)"petrolpark.packet.unsupported.advanced", (Object[])new Object[]{this.id()}) : Component.translatable((String)"petrolpark.packet.unsupported");
            }
        }

        public record Advanced(Component simpleName, Component advancedName) implements Logged
        {
            @Override
            public Component name(TooltipFlag tooltipFlag) {
                return tooltipFlag.isAdvanced() ? this.advancedName() : this.simpleName();
            }
        }

        public record Simple(Component name) implements Logged
        {
            @Override
            public Component name(TooltipFlag tooltipFlag) {
                return this.name();
            }
        }
    }

    public static final class SilentIgnore
    implements ActionRecordEntryResult {
    }
}

