/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.badge;

import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.core.badge.BadgeItem;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Date;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class Badge
implements ItemLike {
    protected ResourceLocation id;
    protected ItemEntry<BadgeItem> itemEntry;
    protected Supplier<Ingredient> duplicationIngredient = () -> Ingredient.EMPTY;

    public void setDuplicationItem(Supplier<Ingredient> ingredient) {
        if (this.duplicationIngredient.get() != Ingredient.EMPTY) {
            throw new UnsupportedOperationException("Cannot modify Badge's duplication Item");
        }
        this.duplicationIngredient = ingredient;
    }

    @Nullable
    public Ingredient getDuplicationIngredient() {
        return this.duplicationIngredient.get();
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public CraftingRecipe getExampleDuplicationRecipe() {
        Ingredient ingredient = this.getDuplicationIngredient();
        if (ingredient == null) {
            return null;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ItemStack stack = BadgeItem.of((Player)minecraft.player, this, new Date(System.currentTimeMillis()));
        return new ShapelessRecipe(this.getId().getNamespace() + "badge_duplication", CraftingBookCategory.MISC, stack, NonNullList.of((Object)Ingredient.of((ItemStack[])new ItemStack[]{stack}), (Object[])new Ingredient[]{ingredient}));
    }

    public void setId(ResourceLocation id) {
        if (this.id != null) {
            throw new UnsupportedOperationException("Cannot change a Badge's ID");
        }
        this.id = id;
    }

    public void setBadgeItem(ItemEntry<BadgeItem> entry) {
        if (this.itemEntry != null) {
            throw new UnsupportedOperationException("Cannot reset a Badge's Item");
        }
        this.itemEntry = entry;
    }

    public Component getName() {
        return Component.translatable((String)Util.makeDescriptionId((String)"badge", (ResourceLocation)this.getId()));
    }

    public Component getDescription() {
        return Component.translatable((String)(Util.makeDescriptionId((String)"badge", (ResourceLocation)this.getId()) + ".description"));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public BadgeItem asItem() {
        return (BadgeItem)((Object)this.itemEntry.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Badge)) return false;
        Badge badge = (Badge)obj;
        if (this.getId() == null) return false;
        if (badge.getId() != this.getId()) return false;
        return true;
    }

    @Nullable
    public static Badge getBadge(String namespace, String name) {
        return Badge.getBadge(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)name));
    }

    @Nullable
    public static Badge getBadge(ResourceLocation id) {
        return (Badge)PetrolparkRegistries.BADGES.get(id);
    }
}

