/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.badge;

import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.core.badge.Badge;
import com.petrolpark.core.badge.BadgeAwardLootItemFunction;
import com.petrolpark.core.badge.ReceiveBadgeCriterionTrigger;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BadgeDataProvider
implements AdvancementProvider.AdvancementGenerator,
LootTableSubProvider {
    public BadgeDataProvider() {
    }

    public BadgeDataProvider(HolderLookup.Provider registries) {
    }

    public void generate(@Nonnull HolderLookup.Provider registries, @Nonnull Consumer<AdvancementHolder> saver, @Nonnull ExistingFileHelper existingFileHelper) {
        PetrolparkRegistries.BADGES.forEach(badge -> saver.accept(new Advancement.Builder().parent(new AdvancementHolder(Petrolpark.asResource("badge_root"), null)).display((ItemLike)badge, badge.getName(), badge.getDescription(), null, AdvancementType.TASK, false, false, true).addCriterion("receive", ReceiveBadgeCriterionTrigger.criterion(badge)).requirements(AdvancementRequirements.allOf(Collections.singletonList("receive"))).rewards(AdvancementRewards.Builder.loot(this.lootTableId((Badge)badge))).build(Petrolpark.asResource("badge/" + badge.id.getPath()))));
    }

    public void generate(@Nonnull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
        PetrolparkRegistries.BADGES.forEach(badge -> output.accept(this.lootTableId((Badge)badge), new LootTable.Builder().withPool(new LootPool.Builder().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)badge).apply(BadgeAwardLootItemFunction::new)))));
    }

    private ResourceKey<LootTable> lootTableId(Badge badge) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Petrolpark.asResource("badge/" + badge.getId().getPath()));
    }
}

