/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.codec;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import com.petrolpark.core.codec.ContextualEncoder;
import com.petrolpark.core.codec.ContextualMapEncoder;
import java.util.Objects;
import java.util.stream.Stream;

public class ContextualFieldEncoder<CONTEXT, A>
extends ContextualMapEncoder.Implementation<CONTEXT, A> {
    private final String name;
    private final ContextualEncoder<CONTEXT, A> elementCodec;

    public ContextualFieldEncoder(String name, ContextualEncoder<CONTEXT, A> elementCodec) {
        this.name = name;
        this.elementCodec = elementCodec;
    }

    @Override
    public <T> RecordBuilder<T> encode(A input, CONTEXT context, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        return prefix.add(this.name, this.elementCodec.encodeStart(ops, context, input));
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString(this.name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualFieldEncoder that = (ContextualFieldEncoder)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.elementCodec, that.elementCodec);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.elementCodec);
    }

    public String toString() {
        return "FieldEncoder[" + this.name + ": " + String.valueOf(this.elementCodec) + "]";
    }
}

