/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.codec;

import com.mojang.serialization.CompressorHolder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.KeyCompressor;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.RecordBuilder;
import java.util.stream.Stream;

public interface ContextualMapEncoder<CONTEXT, A>
extends Keyable {
    public <T> RecordBuilder<T> encode(A var1, CONTEXT var2, DynamicOps<T> var3, RecordBuilder<T> var4);

    default public <T> RecordBuilder<T> compressedBuilder(DynamicOps<T> ops) {
        if (ops.compressMaps()) {
            return MapEncoder.makeCompressedBuilder(ops, this.compressor(ops));
        }
        return ops.mapBuilder();
    }

    public <T> KeyCompressor<T> compressor(DynamicOps<T> var1);

    public static <CONTEXT, A> ContextualMapEncoder<CONTEXT, A> empty() {
        return new Implementation<CONTEXT, A>(){

            @Override
            public <T> RecordBuilder<T> encode(A input, CONTEXT context, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                return prefix;
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.empty();
            }

            public String toString() {
                return "EmptyEncoder";
            }
        };
    }

    public static abstract class Implementation<CONTEXT, A>
    extends CompressorHolder
    implements ContextualMapEncoder<CONTEXT, A> {
    }
}

