/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.codec;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;

public record EitherDecoder<F, S>(Decoder<F> first, Decoder<S> second) implements Decoder<Either<F, S>>
{
    public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> ops, T input) {
        DataResult firstRead = this.first.decode(ops, input).map(vo -> vo.mapFirst(Either::left));
        if (firstRead.isSuccess()) {
            return firstRead;
        }
        DataResult secondRead = this.second.decode(ops, input).map(vo -> vo.mapFirst(Either::right));
        if (secondRead.isSuccess()) {
            return secondRead;
        }
        if (firstRead.hasResultOrPartial()) {
            return firstRead;
        }
        if (secondRead.hasResultOrPartial()) {
            return secondRead;
        }
        return DataResult.error(() -> "Failed to parse either. First: " + ((DataResult.Error)firstRead.error().orElseThrow()).message() + "; Second: " + ((DataResult.Error)secondRead.error().orElseThrow()).message());
    }

    public static <T> Decoder<T> withAlternative(Decoder<T> primary, Decoder<? extends T> alternative) {
        return new EitherDecoder<T, T>(primary, alternative).map(Either::unwrap);
    }
}

