/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.contamination;

import com.petrolpark.core.contamination.Contaminable;
import com.petrolpark.core.contamination.Contaminant;
import com.petrolpark.util.Pair;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public abstract class BuiltInRegistryContaminable<OBJECT, OBJECT_STACK>
extends Contaminable<OBJECT, OBJECT_STACK> {
    public final Registry<OBJECT> builtInRegistry;

    public BuiltInRegistryContaminable(Registry<OBJECT> builtInRegistry) {
        this.builtInRegistry = builtInRegistry;
    }

    @Override
    public Map<OBJECT, Set<Holder<Contaminant>>> getIntrinsicContaminants(RegistryAccess registryAccess) {
        return this.getContaminantsFromTags(registryAccess, Contaminant::getKeyFromInstrinsicTag);
    }

    @Override
    public Map<OBJECT, Set<Holder<Contaminant>>> getShownIfAbsentContaminants(RegistryAccess registryAccess) {
        return this.getContaminantsFromTags(registryAccess, Contaminant::getKeyFromShownIfAbsentTag);
    }

    protected Map<OBJECT, Set<Holder<Contaminant>>> getContaminantsFromTags(RegistryAccess registryAccess, Function<TagKey<?>, ResourceKey<Contaminant>> contaminantKeyGetter) {
        return this.builtInRegistry.asLookup().listElements().map(holder -> Pair.of(holder.value(), BuiltInRegistryContaminable.withChildren(holder.tags().map(contaminantKeyGetter::apply).dropWhile(Objects::isNull).map(arg_0 -> ((RegistryAccess)registryAccess).holder(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet())))).dropWhile(pair -> ((Set)pair.getSecond()).isEmpty()).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public static Set<Holder<Contaminant>> withChildren(Set<Holder<Contaminant>> contaminants) {
        return Stream.concat(contaminants.stream(), contaminants.stream().map(Holder::value).map(Contaminant::getChildren).flatMap(Collection::stream)).collect(Collectors.toSet());
    }
}

