/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.contamination;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.core.contamination.IntrinsicContaminants;
import com.petrolpark.util.GraphHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

public class Contaminant {
    public static final Codec<Contaminant> DIRECT_CODEC = ExtraCodecs.catchDecoderException((Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)0.0, (double)1.0).fieldOf("preservationProportion").forGetter(Contaminant::getPreservationProportion), (App)Codec.intRange((int)0, (int)0xFFFFFF).fieldOf("color").forGetter(Contaminant::getColor), (App)Codec.intRange((int)0, (int)0xFFFFFF).fieldOf("absentColor").forGetter(Contaminant::getAbsentColor), (App)RegistryCodecs.homogeneousList(PetrolparkRegistries.Keys.CONTAMINANT).optionalFieldOf("children", (Object)HolderSet.direct((Holder[])new Holder[0])).forGetter(Contaminant::getDirectChildrenHolders)).apply((Applicative)instance, Contaminant::new)));
    public static final Codec<Holder<Contaminant>> CODEC = RegistryFixedCodec.create(PetrolparkRegistries.Keys.CONTAMINANT);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Contaminant>> STREAM_CODEC = ByteBufCodecs.holderRegistry(PetrolparkRegistries.Keys.CONTAMINANT);
    public final double preservationProportion;
    public final int color;
    public final int absentColor;
    protected final HolderSet<Contaminant> directChildrenHolders;
    protected final Set<Holder<Contaminant>> childrenHolders;
    protected final Set<Holder<Contaminant>> parentHolders = new HashSet<Holder<Contaminant>>();
    protected String descriptionId;
    protected String absentDescriptionId;
    protected Set<Holder<Contaminant>> childrenView = null;
    protected Set<Holder<Contaminant>> parentsView = null;

    public static int compareHolders(Holder<Contaminant> holder1, Holder<Contaminant> holder2) {
        return holder1.unwrapKey().map(ResourceKey::location).flatMap(rl1 -> holder2.unwrapKey().map(ResourceKey::location).map(rl2 -> rl1.compareTo(rl2))).orElse(0);
    }

    public static ResourceKey<Contaminant> getKeyFromInstrinsicTag(TagKey<?> tagKey) {
        return Contaminant.getKeyFromTag(tagKey, "intrinsic");
    }

    public static ResourceKey<Contaminant> getKeyFromShownIfAbsentTag(TagKey<?> tagKey) {
        return Contaminant.getKeyFromTag(tagKey, "show_if_absent");
    }

    public static ResourceKey<Contaminant> getKeyFromTag(TagKey<?> tagKey, String pathSuffix) {
        ResourceLocation rl = tagKey.location();
        String[] path = rl.getPath().split("/");
        if (!path[0].equals("contaminant") || !path[2].equals(pathSuffix)) {
            return null;
        }
        return ResourceKey.create(PetrolparkRegistries.Keys.CONTAMINANT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)path[1]));
    }

    public Contaminant(double preservationProportion, int color, int absentColor, HolderSet<Contaminant> directChildrenHolders) {
        this.preservationProportion = preservationProportion;
        this.color = color;
        this.absentColor = absentColor;
        this.directChildrenHolders = directChildrenHolders;
        this.childrenHolders = new HashSet<Holder<Contaminant>>(directChildrenHolders.size());
        directChildrenHolders.forEach(this.childrenHolders::add);
    }

    public double getPreservationProportion() {
        return this.preservationProportion;
    }

    public boolean isPreserved(double proportion) {
        if (this.preservationProportion == 0.0) {
            return proportion > 0.0;
        }
        return proportion >= this.preservationProportion;
    }

    public int getColor() {
        return this.color;
    }

    public int getAbsentColor() {
        return this.absentColor;
    }

    protected HolderSet<Contaminant> getDirectChildrenHolders() {
        return this.directChildrenHolders;
    }

    public Set<Holder<Contaminant>> getChildren() {
        if (this.childrenView == null) {
            this.childrenView = this.childrenHolders.stream().collect(Collectors.toUnmodifiableSet());
        }
        return this.childrenView;
    }

    public Set<Holder<Contaminant>> getParents() {
        if (this.parentsView == null) {
            this.parentsView = this.parentHolders.stream().collect(Collectors.toUnmodifiableSet());
        }
        return this.parentsView;
    }

    public static Component getName(Holder<Contaminant> contaminantHolder) {
        Contaminant contaminant = (Contaminant)contaminantHolder.value();
        if (contaminant.descriptionId == null) {
            contaminant.descriptionId = Util.makeDescriptionId((String)"contaminant", (ResourceLocation)contaminantHolder.getKey().location());
        }
        return Component.translatable((String)contaminant.descriptionId);
    }

    public static Component getNameColored(Holder<Contaminant> contaminantHolder) {
        return Contaminant.getName(contaminantHolder).copy().withStyle(Style.EMPTY.withColor(((Contaminant)contaminantHolder.value()).color));
    }

    public static Component getAbsentName(Holder<Contaminant> contaminantHolder) {
        Contaminant contaminant = (Contaminant)contaminantHolder.value();
        if (contaminant.absentDescriptionId == null) {
            contaminant.absentDescriptionId = Util.makeDescriptionId((String)"contaminant", (ResourceLocation)contaminantHolder.getKey().location()) + ".absent";
        }
        return Component.translatable((String)contaminant.absentDescriptionId);
    }

    public static Component getAbsentNameColored(Holder<Contaminant> contaminantHolder) {
        return Contaminant.getAbsentName(contaminantHolder).copy().withStyle(Style.EMPTY.withColor(((Contaminant)contaminantHolder.value()).absentColor));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Contaminant)) return false;
        Contaminant contaminant = (Contaminant)obj;
        if (contaminant.preservationProportion != this.preservationProportion) return false;
        if (contaminant.color != this.color) return false;
        if (contaminant.absentColor != this.absentColor) return false;
        if (!contaminant.directChildrenHolders.equals(this.directChildrenHolders)) return false;
        return true;
    }

    public static class ReloadListener
    implements ResourceManagerReloadListener {
        public final RegistryAccess registryAccess;

        public ReloadListener(RegistryAccess registryAccess) {
            this.registryAccess = registryAccess;
        }

        public void onResourceManagerReload(@Nonnull ResourceManager resourceManager) {
            Registry registry = this.registryAccess.registryOrThrow(PetrolparkRegistries.Keys.CONTAMINANT);
            registry.asLookup().listElements().forEach(parentHolder -> ((Contaminant)parentHolder.value()).directChildrenHolders.forEach(childHolder -> ((Contaminant)childHolder.value()).parentHolders.add((Holder<Contaminant>)parentHolder)));
            registry.asLookup().listElements().forEach(parentHolder -> {
                try {
                    for (Holder descendantHolder : GraphHelper.getAllDescendants(parentHolder, h -> ((Contaminant)h.value()).directChildrenHolders)) {
                        ((Contaminant)parentHolder.value()).childrenHolders.add((Holder<Contaminant>)descendantHolder);
                        ((Contaminant)descendantHolder.value()).parentHolders.add((Holder<Contaminant>)parentHolder);
                    }
                }
                catch (GraphHelper.CircularReferenceException e) {
                    throw new JsonSyntaxException(String.format("Contaminant %s is its own descendant. Replace the circular reference with a single Contaminant", parentHolder.getKey().location().toString()));
                }
            });
            IntrinsicContaminants.clear();
        }
    }
}

