/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.contamination;

import com.mojang.serialization.Codec;
import com.petrolpark.core.contamination.Contaminant;
import com.petrolpark.core.contamination.IContamination;
import com.petrolpark.core.contamination.IntrinsicContaminants;
import com.petrolpark.util.CodecHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public abstract class Contamination<OBJECT, OBJECT_STACK>
implements IContamination<OBJECT, OBJECT_STACK> {
    public static final Codec<List<Holder<Contaminant>>> ORPHAN_HOLDER_LIST_CODEC = Codec.list(Contaminant.CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<Holder<Contaminant>>> ORPHAN_HOLDER_LIST_STREAM_CODEC = CodecHelper.listStream(Contaminant.STREAM_CODEC);
    protected final OBJECT_STACK stack;
    protected final SortedSet<Holder<Contaminant>> orphanContaminants = new TreeSet<Holder<Contaminant>>(Contaminant::compareHolders);
    protected final Set<Holder<Contaminant>> contaminants = new HashSet<Holder<Contaminant>>();

    protected Contamination(OBJECT_STACK stack) {
        this.stack = stack;
    }

    @Override
    public final boolean has(Holder<Contaminant> contaminant) {
        return this.isIntrinsic(contaminant) || this.contaminants.contains(contaminant);
    }

    @Override
    public final boolean hasAnyContaminant() {
        return !IntrinsicContaminants.get(this).isEmpty() || this.hasAnyExtrinsicContaminant();
    }

    @Override
    public final boolean hasAnyExtrinsicContaminant() {
        return !this.contaminants.isEmpty();
    }

    @Override
    public final Stream<Holder<Contaminant>> streamAllContaminants() {
        return Stream.concat(this.streamIntrinsicContaminants(), this.contaminants.stream());
    }

    @Override
    public final Stream<Holder<Contaminant>> streamOrphanExtrinsicContaminants() {
        return this.orphanContaminants.stream();
    }

    @Override
    public final boolean contaminate(Holder<Contaminant> contaminant) {
        if (this.isIntrinsic(contaminant)) {
            return false;
        }
        if (!this.contaminants.add(contaminant)) {
            return false;
        }
        this.orphanContaminants.removeAll(((Contaminant)contaminant.value()).getChildren());
        this.orphanContaminants.add(contaminant);
        this.contaminants.addAll(((Contaminant)contaminant.value()).getChildren());
        this.save();
        return true;
    }

    @Override
    public final boolean contaminateAll(Stream<Holder<Contaminant>> contaminantsStream) {
        boolean changed;
        boolean bl = changed = !contaminantsStream.dropWhile(this::isIntrinsic).filter(this.contaminants::add).map(contaminant -> {
            this.orphanContaminants.removeAll(((Contaminant)contaminant.value()).getChildren());
            this.orphanContaminants.add((Holder<Contaminant>)contaminant);
            this.contaminants.addAll(((Contaminant)contaminant.value()).getChildren());
            return contaminant;
        }).toList().isEmpty();
        if (changed) {
            this.save();
        }
        return changed;
    }

    @Override
    public final boolean decontaminate(Holder<Contaminant> contaminant) {
        if (this.isIntrinsic(contaminant)) {
            return false;
        }
        if (!this.orphanContaminants.remove(contaminant)) {
            return false;
        }
        this.contaminants.remove(contaminant);
        for (Holder<Contaminant> child : ((Contaminant)contaminant.value()).getChildren()) {
            if (!Collections.disjoint(this.contaminants, ((Contaminant)child.value()).getParents())) continue;
            this.contaminants.remove(child);
        }
        this.save();
        return true;
    }

    @Override
    public final boolean decontaminateOnly(Holder<Contaminant> contaminant) {
        if (this.isIntrinsic(contaminant)) {
            return false;
        }
        if (!this.orphanContaminants.remove(contaminant)) {
            return false;
        }
        this.contaminants.remove(contaminant);
        for (Holder<Contaminant> child : ((Contaminant)contaminant.value()).getChildren()) {
            if (!Collections.disjoint(this.contaminants, ((Contaminant)child.value()).getParents())) continue;
            this.orphanContaminants.add(child);
        }
        this.save();
        return true;
    }

    @Override
    public final boolean fullyDecontaminate() {
        if (this.orphanContaminants.isEmpty()) {
            return false;
        }
        this.orphanContaminants.clear();
        this.contaminants.clear();
        this.save();
        return true;
    }

    protected List<Holder<Contaminant>> getOrphanHolderList() {
        return this.orphanContaminants.stream().toList();
    }
}

