/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.contamination;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkLootItemFunctions;
import com.petrolpark.core.contamination.Contaminant;
import com.petrolpark.core.contamination.IContamination;
import com.petrolpark.core.contamination.ItemContamination;
import java.util.Locale;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;

public record ContaminationLootItemFunction(Holder<Contaminant> contaminantHolder, Action action) implements LootItemFunction
{
    public static final MapCodec<ContaminationLootItemFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Contaminant.CODEC.fieldOf("contaminant").forGetter(ContaminationLootItemFunction::contaminantHolder), (App)Action.CODEC.optionalFieldOf("action", (Object)Action.ADD).forGetter(ContaminationLootItemFunction::action)).apply((Applicative)instance, ContaminationLootItemFunction::new));

    public ItemStack apply(ItemStack stack, LootContext context) {
        this.action().apply(ItemContamination.get(stack), this.contaminantHolder());
        return stack;
    }

    public LootItemFunctionType<? extends LootItemFunction> getType() {
        return (LootItemFunctionType)PetrolparkLootItemFunctions.CONTAMINATION.get();
    }

    public static enum Action implements StringRepresentable
    {
        ADD{

            @Override
            public void apply(IContamination<?, ?> contamination, Holder<Contaminant> contaminantHolder) {
                contamination.contaminate(contaminantHolder);
            }
        }
        ,
        REMOVE{

            @Override
            public void apply(IContamination<?, ?> contamination, Holder<Contaminant> contaminantHolder) {
                contamination.decontaminate(contaminantHolder);
            }
        }
        ,
        REMOVE_ONLY{

            @Override
            public void apply(IContamination<?, ?> contamination, Holder<Contaminant> contaminantHolder) {
                contamination.decontaminateOnly(contaminantHolder);
            }
        };

        public static final Codec<Action> CODEC;
        public static final StreamCodec<RegistryFriendlyByteBuf, Action> STREAM_CODEC;

        public abstract void apply(IContamination<?, ?> var1, Holder<Contaminant> var2);

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Action::values);
            STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(Action.class);
        }
    }
}

