/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.contamination;

import com.petrolpark.core.contamination.ComponentHolderContamination;
import com.petrolpark.core.contamination.Contaminable;
import com.petrolpark.core.contamination.Contaminables;
import com.petrolpark.core.contamination.IContamination;
import com.petrolpark.core.contamination.IncontaminableContamination;
import com.petrolpark.core.contamination.ItemContaminationSavedEvent;
import com.petrolpark.core.item.IItemStackDuck;
import java.util.stream.Stream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ItemContamination
extends ComponentHolderContamination<Item, ItemStack> {
    public static IContamination<?, ?> create(ItemStack stack) {
        if (!Contaminables.ITEM.isContaminableStack(stack)) {
            return IncontaminableContamination.INSTANCE;
        }
        return new ItemContamination(stack);
    }

    public static IContamination<?, ?> get(ItemStack stack) {
        return ItemContamination.getDuck(stack).getContamination();
    }

    public static final void perpetuateSingle(Stream<ItemStack> inputs, ItemStack output) {
        ItemContamination.perpetuate(inputs.map(stack -> stack.copyWithCount(1)), Stream.of(output));
    }

    public static final void perpetuateSingle(Stream<ItemStack> inputs, Stream<ItemStack> outputs) {
        ItemContamination.perpetuate(inputs.map(stack -> stack.copyWithCount(1)), outputs);
    }

    public static final void perpetuate(Stream<ItemStack> inputs, Stream<ItemStack> outputs) {
        IContamination.perpetuate(inputs.dropWhile(ItemStack::isEmpty), outputs, ItemContamination::get);
    }

    protected ItemContamination(ItemStack stack) {
        super(stack);
    }

    @Override
    public Contaminable<Item, ItemStack> getContaminable() {
        return Contaminables.ITEM;
    }

    @Override
    public Item getType() {
        return ((ItemStack)this.stack).getItem();
    }

    @Override
    public double getAmount() {
        return ((ItemStack)this.stack).getCount();
    }

    @Override
    public void save() {
        super.save();
        ItemContamination.getDuck((ItemStack)this.stack).onContaminationSaved();
        NeoForge.EVENT_BUS.post((Event)new ItemContaminationSavedEvent((ItemStack)this.stack, this));
    }

    protected static IItemStackDuck getDuck(ItemStack stack) {
        return (IItemStackDuck)stack;
    }
}

