/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public interface IEntityTarget
extends StringRepresentable {
    public static final Map<ResourceLocation, LootContextParam<? extends Entity>> CUSTOM = new HashMap<ResourceLocation, LootContextParam<? extends Entity>>();
    public static final Codec<IEntityTarget> CODEC = Codec.stringResolver(StringRepresentable::getSerializedName, IEntityTarget::getByName);
    public static final IEntityTarget CONTEXT_THIS = Targets.TARGETS.computeIfAbsent(LootContext.EntityTarget.THIS.name(), s -> new BuiltIn(LootContext.EntityTarget.THIS));

    public static void register(LootContextParam<? extends Entity> lootContextParam) {
        CUSTOM.put(lootContextParam.getName(), lootContextParam);
    }

    public Component getName();

    public static Component getName(LootContextParam<? extends Entity> param) {
        return Component.translatable((String)Util.makeDescriptionId((String)"loot_context_param", (ResourceLocation)param.getName()));
    }

    public Entity get(LootContext var1);

    public LootContextParam<? extends Entity> getReferencedParam();

    public static IEntityTarget getByName(String name) {
        try {
            LootContext.EntityTarget builtInTarget = LootContext.EntityTarget.getByName((String)name);
            return Targets.TARGETS.computeIfAbsent(name, s -> new BuiltIn(builtInTarget));
        }
        catch (IllegalArgumentException e) {
            LootContextParam<? extends Entity> param = CUSTOM.get(ResourceLocation.parse((String)name));
            if (param != null) {
                return Targets.TARGETS.putIfAbsent(name, new Custom(param));
            }
            throw new IllegalArgumentException("Unknown contextual Entity: " + name);
        }
    }

    public static class Targets {
        private static final Map<String, IEntityTarget> TARGETS = new HashMap<String, IEntityTarget>();

        static {
            IEntityTarget.register((LootContextParam<? extends Entity>)LootContextParams.THIS_ENTITY);
            IEntityTarget.register((LootContextParam<? extends Entity>)LootContextParams.ATTACKING_ENTITY);
            IEntityTarget.register((LootContextParam<? extends Entity>)LootContextParams.LAST_DAMAGE_PLAYER);
        }
    }

    public static class Custom
    implements IEntityTarget {
        public final LootContextParam<? extends Entity> param;

        public Custom(LootContextParam<? extends Entity> param) {
            this.param = param;
        }

        @Override
        public Entity get(LootContext context) {
            return (Entity)context.getParamOrNull(this.param);
        }

        @Override
        public Component getName() {
            return IEntityTarget.getName(this.param);
        }

        public String getSerializedName() {
            return this.param.getName().toString();
        }

        @Override
        public LootContextParam<? extends Entity> getReferencedParam() {
            return this.param;
        }
    }

    public static class BuiltIn
    implements IEntityTarget {
        public final LootContext.EntityTarget target;

        public BuiltIn(LootContext.EntityTarget target) {
            this.target = target;
        }

        @Override
        public Entity get(LootContext context) {
            return (Entity)context.getParamOrNull(this.target.getParam());
        }

        @Override
        public Component getName() {
            return IEntityTarget.getName((LootContextParam<? extends Entity>)this.target.getParam());
        }

        public String getSerializedName() {
            return this.target.getName();
        }

        @Override
        public LootContextParam<? extends Entity> getReferencedParam() {
            return this.target.getParam();
        }
    }
}

