/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.loot.numberprovider;

import com.petrolpark.PetrolparkLootContextParams;
import com.petrolpark.PetrolparkNumberProviderTypes;
import com.petrolpark.core.shop.customer.ICustomer;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class CustomerWaitTimeNumberProvider
implements NumberProvider {
    public float getFloat(@Nonnull LootContext context) {
        ICustomer customer = (ICustomer)context.getParam(PetrolparkLootContextParams.CUSTOMER);
        if (customer == null) {
            return 1.0f;
        }
        if (customer.getOrderTime() == -1) {
            return 1.0f;
        }
        return 1.0f - (float)customer.getElapsedOrderTime() / (float)customer.getOrderTime();
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)PetrolparkNumberProviderTypes.CUSTOMER_WAIT_TIME.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Collections.singleton(PetrolparkLootContextParams.CUSTOMER);
    }
}

