/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.loot.numberprovider.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkNumberProviderTypes;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import com.petrolpark.core.data.loot.numberprovider.entity.EntityNumberProvider;
import com.petrolpark.core.data.loot.numberprovider.entity.LootEntityNumberProviderType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record EntityPredicateNumberProvider(EntityPredicate predicate, Either<NumberProvider, EntityNumberProvider> pass, Either<NumberProvider, EntityNumberProvider> fail) implements EntityNumberProvider
{
    public static final MapCodec<EntityPredicateNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntityPredicate.CODEC.fieldOf("predicate").forGetter(EntityPredicateNumberProvider::predicate), (App)Codec.either((Codec)NumberProviders.CODEC, EntityNumberProvider.CODEC).fieldOf("pass").forGetter(EntityPredicateNumberProvider::pass), (App)Codec.either((Codec)NumberProviders.CODEC, EntityNumberProvider.CODEC).fieldOf("fail").forGetter(EntityPredicateNumberProvider::fail)).apply((Applicative)instance, EntityPredicateNumberProvider::new));

    @Override
    public float getFloat(Entity entity, LootContext lootContext) {
        return ((Float)(this.predicate().matches(lootContext.getLevel(), null, entity) ? this.pass : this.fail).map(np -> Float.valueOf(np.getFloat(lootContext)), enp -> Float.valueOf(enp.getFloat(entity, lootContext)))).floatValue();
    }

    @Override
    public NumberEstimate getEstimate() {
        return ((NumberEstimate)this.pass.map(NumberEstimate::get, EntityNumberProvider::getEstimate)).or((NumberEstimate)this.fail.map(NumberEstimate::get, EntityNumberProvider::getEstimate));
    }

    @Override
    public LootEntityNumberProviderType getType() {
        return (LootEntityNumberProviderType)PetrolparkNumberProviderTypes.ENTITY_PREDICATE.get();
    }
}

