/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.predicate.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.util.ColorHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

public record ColorEntitySubPredicate(List<DyeColor> colors) implements EntitySubPredicate
{
    public static final MapCodec<ColorEntitySubPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.listOf().fieldOf("colors").forGetter(ColorEntitySubPredicate::colors)).apply((Applicative)instance, ColorEntitySubPredicate::new));

    public MapCodec<? extends EntitySubPredicate> codec() {
        return CODEC;
    }

    public boolean matches(@Nonnull Entity entity, @Nonnull ServerLevel level, @Nullable Vec3 position) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            DyeColor color = ColorHelper.getColor(livingEntity);
            if (color == null) {
                return this.colors.isEmpty();
            }
            return this.colors.contains(color);
        }
        return false;
    }
}

