/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.reward;

import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkLootContextParams;
import com.petrolpark.PetrolparkRewardTypes;
import com.petrolpark.core.data.reward.IReward;
import com.petrolpark.core.data.reward.RewardType;
import com.petrolpark.core.data.reward.team.ITeamReward;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record ContextTeamReward(ITeamReward reward) implements IReward
{
    public static final MapCodec<ContextTeamReward> CODEC = CodecHelper.singleFieldMap(ITeamReward.CODEC, "reward", ContextTeamReward::reward, ContextTeamReward::new);

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics) {
        this.reward.render(graphics);
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder builder) {
        builder.add(this.translateSimple(new Object[0]));
        builder.indent();
        this.reward().addToDescription(builder);
        builder.unindent();
    }

    @Override
    public void reward(LootContext context, float multiplier) {
        ITeam team = (ITeam)context.getParam(PetrolparkLootContextParams.TEAM);
        if (team != null) {
            this.reward.reward(team, context, multiplier);
        }
    }

    @Override
    public RewardType getType() {
        return (RewardType)PetrolparkRewardTypes.CONTEXT_TEAM.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Collections.singleton(PetrolparkLootContextParams.TEAM);
    }
}

