/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.reward.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.core.data.IEntityTarget;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import com.petrolpark.core.data.reward.entity.EntityRewardType;
import com.petrolpark.core.data.reward.entity.IEntityReward;
import com.petrolpark.util.Lang;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record VillagerGossipEntityReward(GossipType type, NumberProvider value, IEntityTarget target) implements IEntityReward
{
    public static final MapCodec<VillagerGossipEntityReward> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GossipType.CODEC.fieldOf("gossip_type").forGetter(VillagerGossipEntityReward::type), (App)NumberProviders.CODEC.fieldOf("value").forGetter(VillagerGossipEntityReward::value), (App)IEntityTarget.CODEC.fieldOf("target").forGetter(VillagerGossipEntityReward::target)).apply((Applicative)instance, VillagerGossipEntityReward::new));

    @Override
    public void reward(Entity entity, LootContext context, float multiplier) {
        Entity target = this.target().get(context);
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            if (target != null) {
                villager.getGossips().add(target.getUUID(), this.type, this.value.getInt(context));
            }
        }
    }

    @Override
    public EntityRewardType getType() {
        throw new UnsupportedOperationException("Unimplemented method 'getType'");
    }

    @Override
    public void render(GuiGraphics graphics) {
        throw new UnsupportedOperationException("Unimplemented method 'render'");
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder builder) {
        NumberEstimate amount = NumberEstimate.get(this.value());
        if (amount.unknown()) {
            builder.add(this.translate("unknown_amount", Lang.gossipType(this.type), this.target().getName()));
        } else {
            builder.add(this.translateSimple(amount.getIntComponent(), Lang.gossipType(this.type), this.target.getName()));
        }
    }
}

