/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.reward.generator;

import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkRewardGeneratorTypes;
import com.petrolpark.core.data.reward.IReward;
import com.petrolpark.core.data.reward.generator.IRewardGenerator;
import com.petrolpark.core.data.reward.generator.RewardGeneratorType;
import com.petrolpark.util.CodecHelper;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;

public record CombinedRewardGenerator(List<IRewardGenerator> values) implements IRewardGenerator
{
    public static final MapCodec<CombinedRewardGenerator> CODEC = CodecHelper.singleFieldMap(IRewardGenerator.CODEC.listOf(), "values", CombinedRewardGenerator::values, CombinedRewardGenerator::new);

    @Override
    public List<IReward> generate(LootContext context) {
        return this.values.stream().map(rg -> rg.generate(context)).flatMap(Collection::stream).toList();
    }

    @Override
    public RewardGeneratorType getType() {
        return (RewardGeneratorType)PetrolparkRewardGeneratorTypes.COMBINED.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.values.stream().map(LootContextUser::getReferencedContextParams).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

