/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.reward.team;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkDataComponents;
import com.petrolpark.PetrolparkLootContextParams;
import com.petrolpark.PetrolparkRewardTypes;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import com.petrolpark.core.data.reward.team.ITeamReward;
import com.petrolpark.core.data.reward.team.TeamRewardType;
import com.petrolpark.core.shop.Shop;
import com.petrolpark.core.shop.ShopsData;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.util.Lang;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record GrantShopXPTeamReward(Holder<Shop> shop, NumberProvider amount) implements ITeamReward
{
    public static final MapCodec<GrantShopXPTeamReward> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Shop.CODEC.fieldOf("shop").forGetter(GrantShopXPTeamReward::shop), (App)NumberProviders.CODEC.fieldOf("amount").forGetter(GrantShopXPTeamReward::amount)).apply((Applicative)instance, GrantShopXPTeamReward::new));

    @Override
    public void reward(ITeam team, LootContext context, float multiplier) {
        ((ShopsData)team.getOrDefault(PetrolparkDataComponents.SHOPS_DATA, new ShopsData())).grantXP(this.shop, this.amount.getInt(context));
    }

    @Override
    public void render(GuiGraphics graphics) {
        throw new UnsupportedOperationException("Unimplemented method 'render'");
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder builder) {
        NumberEstimate amount = NumberEstimate.get(this.amount());
        if (amount.unknown()) {
            builder.add(this.translate("unknown_amount", ((Shop)this.shop.value()).getName()));
        } else {
            builder.add(this.translateSimple(amount.getIntComponent(), ((Shop)this.shop.value()).getName()));
        }
    }

    @Override
    public TeamRewardType getType() {
        return (TeamRewardType)PetrolparkRewardTypes.GRANT_SHOP_XP.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Sets.union(Collections.singleton(PetrolparkLootContextParams.TEAM), (Set)this.amount.getReferencedContextParams());
    }
}

