/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.item;

import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class QueueItemHandler
implements IItemHandler,
INBTSerializable<ListTag> {
    protected final Queue<ItemStack> stacks = new LinkedList<ItemStack>();

    public boolean isEmpty() {
        this.skimEmptyStacks();
        return this.stacks.isEmpty();
    }

    public final int getSlots() {
        return 1;
    }

    public void skimEmptyStacks() {
        while (this.stacks.peek() != null && this.stacks.peek().isEmpty() && !this.stacks.isEmpty()) {
            this.stacks.poll();
        }
    }

    public ItemStack peekStack() {
        this.skimEmptyStacks();
        return Optional.ofNullable(this.stacks.peek()).orElse(ItemStack.EMPTY);
    }

    public ItemStack pollStack() {
        this.skimEmptyStacks();
        ItemStack stack = this.stacks.poll();
        if (stack == null) {
            return ItemStack.EMPTY;
        }
        if (!stack.isEmpty()) {
            this.onContentsChanged();
        }
        return stack;
    }

    public ItemStack add(ItemStack stack) {
        if (stack.isEmpty() || !this.isItemValid(stack)) {
            return stack;
        }
        ItemStack toInsert = stack.copy();
        for (ItemStack existing : this.stacks) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)toInsert)) continue;
            int added = Math.min(toInsert.getCount(), Math.min(existing.getMaxStackSize(), this.getStackSizeLimit()) - existing.getCount());
            existing.grow(added);
            toInsert.shrink(added);
        }
        while (!toInsert.isEmpty()) {
            int added = Math.min(toInsert.getCount(), this.getStackSizeLimit());
            this.stacks.add(toInsert.copyWithCount(added));
            toInsert.shrink(added);
        }
        this.onContentsChanged();
        return ItemStack.EMPTY;
    }

    @NotNull
    public final ItemStack getStackInSlot(int slot) {
        return this.peekStack();
    }

    @NotNull
    public final ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (simulate) {
            return this.isItemValid(stack) ? ItemStack.EMPTY : stack;
        }
        return this.add(stack);
    }

    @NotNull
    public final ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.peekStack();
        if (amount >= stack.getCount()) {
            return simulate ? stack : this.pollStack();
        }
        ItemStack extracted = stack.copyWithCount(amount);
        if (!simulate) {
            stack.shrink(amount);
            this.onContentsChanged();
        }
        return extracted;
    }

    public final int getSlotLimit(int slot) {
        return this.getStackSizeLimit();
    }

    public int getStackSizeLimit() {
        return Integer.MAX_VALUE;
    }

    public final boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.isItemValid(stack);
    }

    public boolean isItemValid(ItemStack stack) {
        return true;
    }

    public ListTag serializeNBT(@Nonnull HolderLookup.Provider registries) {
        ListTag listTag = new ListTag();
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            listTag.add((Object)stack.save(registries));
        }
        return listTag;
    }

    public void deserializeNBT(@Nonnull HolderLookup.Provider registries, @Nonnull ListTag nbt) {
        this.stacks.clear();
        for (int i = 0; i < nbt.size(); ++i) {
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound(i));
            if (stack.isEmpty()) continue;
            this.stacks.add(stack);
        }
        this.onLoad();
    }

    protected void onContentsChanged() {
    }

    protected void onLoad() {
    }
}

