/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.bogglepattern;

import com.mojang.serialization.Codec;
import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.core.recipe.bogglepattern.generator.IBogglePatternGenerator;
import com.petrolpark.util.CodecHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class BogglePattern {
    public static final Codec<BogglePattern> DIRECT_CODEC = CodecHelper.singleField(IBogglePatternGenerator.CODEC, "generator", BogglePattern::getGenerator, BogglePattern::new);
    public static final Codec<BogglePattern> DIRECT_NETWORK_CODEC = CodecHelper.singleField(IBogglePatternGenerator.NETWORK_CODEC, "generator", BogglePattern::getGenerator, BogglePattern::new);
    protected final IBogglePatternGenerator generator;
    private Integer pattern;

    public BogglePattern(IBogglePatternGenerator generator) {
        this.generator = generator;
    }

    public IBogglePatternGenerator getGenerator() {
        return this.generator;
    }

    @Nullable
    public Integer getPattern() {
        return this.pattern;
    }

    public int getOrGeneratePattern(Level level) {
        if (this.pattern == null) {
            this.pattern = this.generator.generate(level.random);
            Petrolpark.BOGGLE_PATTERNS.markDirty();
        }
        return this.pattern;
    }

    public void forgetPattern() {
        if (this.pattern != null) {
            Petrolpark.BOGGLE_PATTERNS.markDirty();
        }
        this.pattern = null;
    }

    public static class Manager {
        protected BogglePatternSavedData savedData;

        public void playerLogout(Player player) {
        }

        @SubscribeEvent
        public void onLevelLoaded(LevelEvent.Load event) {
            LevelAccessor level = event.getLevel();
            MinecraftServer server = level.getServer();
            if (server == null || server.overworld() != level) {
                return;
            }
            this.savedData = null;
            this.loadSavedData(server);
        }

        private void loadSavedData(MinecraftServer server) {
            if (this.savedData != null) {
                return;
            }
            this.savedData = (BogglePatternSavedData)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new BogglePatternSavedData(this, (Level)server.overworld()), (tag, registries) -> this.load((Level)server.overworld(), (CompoundTag)tag)), "petrolpark_boggle_patterns");
        }

        protected BogglePatternSavedData load(Level overworld, CompoundTag tag) {
            BogglePatternSavedData savedData = new BogglePatternSavedData(this, overworld);
            HolderLookup.RegistryLookup lookup = overworld.registryAccess().lookupOrThrow(PetrolparkRegistries.Keys.BOGGLE_PATTERN);
            for (String key : tag.getAllKeys()) {
                lookup.get(ResourceKey.create(PetrolparkRegistries.Keys.BOGGLE_PATTERN, (ResourceLocation)ResourceLocation.parse((String)key))).ifPresent(holder -> {
                    ((BogglePattern)holder.value()).pattern = tag.getInt(key);
                });
            }
            lookup.listElements().map(Holder::value).forEach(pattern -> pattern.getOrGeneratePattern(overworld));
            return savedData;
        }

        public void markDirty() {
            if (this.savedData != null) {
                this.savedData.setDirty();
            }
        }

        public class BogglePatternSavedData
        extends SavedData {
            protected Level level;

            public BogglePatternSavedData(Manager this$0, Level level) {
                this.level = level;
            }

            public CompoundTag save(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
                registries.lookupOrThrow(PetrolparkRegistries.Keys.BOGGLE_PATTERN).listElements().forEach(holder -> tag.putInt(holder.key().location().toString(), ((BogglePattern)holder.value()).getOrGeneratePattern(this.level)));
                return tag;
            }
        }
    }
}

