/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.book;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.core.recipe.INamedRecipe;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

public record RecipeReferenceDataComponent(ResourceLocation recipeId, Optional<ResourceLocation> jeiRecipeTypeId) {
    public static final Codec<RecipeReferenceDataComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("recipe").forGetter(RecipeReferenceDataComponent::recipeId), (App)ResourceLocation.CODEC.optionalFieldOf("jei_recipe_type").forGetter(RecipeReferenceDataComponent::jeiRecipeTypeId)).apply((Applicative)instance, RecipeReferenceDataComponent::new));
    public static final StreamCodec<FriendlyByteBuf, RecipeReferenceDataComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, RecipeReferenceDataComponent::recipeId, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), RecipeReferenceDataComponent::jeiRecipeTypeId, RecipeReferenceDataComponent::new);

    public Optional<RecipeHolder<?>> getRecipeHolder(RecipeManager recipeManager) {
        return recipeManager.byKey(this.recipeId());
    }

    public Component getRecipeName(RecipeManager recipeManager) {
        return this.getRecipeHolder(recipeManager).map(INamedRecipe::getName).orElse(INamedRecipe.unknownRecipeName());
    }
}

