/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.compat;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapLike;
import com.petrolpark.Petrolpark;
import com.petrolpark.core.recipe.compat.CompatRecipeDeserializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;

public class CompatRecipeManager {
    protected static final String SERIALIZER_KEY = "type";
    protected final Map<ResourceLocation, List<CompatRecipeDeserializer<?>>> compatRecipeDeserializers = new HashMap();
    protected boolean registrationDone = false;
    protected final MapDecoder<List<CompatRecipeDeserializer<?>>> deserializersMapDecoder = new MapDecoder.Implementation<List<CompatRecipeDeserializer<?>>>(){

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(CompatRecipeManager.SERIALIZER_KEY).map(arg_0 -> ops.createString(arg_0));
        }

        public <T> DataResult<List<CompatRecipeDeserializer<?>>> decode(DynamicOps<T> ops, MapLike<T> input) {
            if (ops.compressMaps()) {
                return DataResult.error(() -> "Cannot use CompatRecipeManager decoder with compressing DynamicOps");
            }
            Object serializerIdElement = input.get(CompatRecipeManager.SERIALIZER_KEY);
            if (serializerIdElement == null) {
                return DataResult.success(Collections.emptyList());
            }
            return ResourceLocation.CODEC.parse(ops, serializerIdElement).map(rl -> {
                List<CompatRecipeDeserializer<?>> deserializers = CompatRecipeManager.this.compatRecipeDeserializers.get(rl);
                return deserializers == null ? Collections.emptyList() : deserializers;
            });
        }
    };
    protected final Decoder<List<CompatRecipeDeserializer<?>>> deserializersDecoder = this.deserializersMapDecoder.decoder();

    public final <D extends CompatRecipeDeserializer<?>> D register(D deserializer) {
        List<Object> list;
        if (this.registrationDone) {
            throw new IllegalStateException("New Compat Recipe Deserializers must be registered during initiation");
        }
        if (this.compatRecipeDeserializers.get(deserializer.serializerId()) == null) {
            list = new ArrayList();
            this.compatRecipeDeserializers.put(deserializer.serializerId(), list);
        } else {
            list = this.compatRecipeDeserializers.get(deserializer.serializerId());
        }
        list.add(deserializer);
        return deserializer;
    }

    public void addCompatRecipes(ImmutableMultimap.Builder<RecipeType<?>, RecipeHolder<?>> byTypeRecipeMapBuilder, ImmutableMap.Builder<ResourceLocation, RecipeHolder<?>> byNameRecipeMapBuilder, RegistryOps<JsonElement> registryOps, ResourceLocation recipeId, JsonElement jsonElement) {
        this.deserializersDecoder.parse(registryOps, (Object)jsonElement).resultOrPartial(JsonParseException::new).stream().flatMap(Collection::stream).forEach(deserializer -> {
            if (!deserializer.shouldDeserialize(jsonElement, recipeId)) {
                return;
            }
            DataResult result = deserializer.decoder().parse((DynamicOps)registryOps, (Object)jsonElement);
            result.result().flatMap(Function.identity()).ifPresent(recipe -> {
                ResourceLocation id = deserializer.createId(recipeId);
                RecipeHolder recipeHolder = new RecipeHolder(id, recipe);
                byTypeRecipeMapBuilder.put((Object)recipe.getType(), (Object)recipeHolder);
                byNameRecipeMapBuilder.put((Object)id, (Object)recipeHolder);
            });
            result.ifError(error -> Petrolpark.LOGGER.warn("Skipping loading Compat Recipe {} for recipe \"{}\": {}", new Object[]{deserializer.toString(), recipeId, error.message()}));
        });
    }
}

