/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.crafting;

import com.petrolpark.PetrolparkTags;
import com.petrolpark.core.recipe.ContainerCraftingInput;
import com.petrolpark.core.recipe.crafting.WrappedCraftingRecipe;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ManualOnlyCraftingRecipe
extends WrappedCraftingRecipe {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAllowed(CraftingInput inv) {
        if (!(inv instanceof ContainerCraftingInput)) return false;
        ContainerCraftingInput containerInput = (ContainerCraftingInput)inv;
        if (containerInput.container.menu instanceof InventoryMenu) return true;
        if (!PetrolparkTags.MenuTypes.ALLOWS_MANUAL_ONLY_CRAFTING.matches(containerInput.container.menu)) return false;
        return true;
    }

    public ManualOnlyCraftingRecipe(CraftingRecipe wrappedRecipe) {
        super(wrappedRecipe);
    }

    @Override
    public boolean matches(@Nonnull CraftingInput input, @Nonnull Level level) {
        return super.matches(input, level) && ManualOnlyCraftingRecipe.isAllowed(input);
    }

    public ItemStack getExampleResult(HolderLookup.Provider registries) {
        return this.getResultItem(registries);
    }

    public RecipeSerializer<ManualOnlyCraftingRecipe> getSerializer() {
        throw new UnsupportedOperationException("Unimplemented method 'getSerializer'");
    }
}

