/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkIngredientTypes;
import com.petrolpark.core.recipe.ingredient.advanced.FluidAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredient;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredientType;

public class AdvancedFluidIngredient
extends FluidIngredient {
    public static final MapCodec<AdvancedFluidIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidAdvancedIngredient.CODEC.fieldOf("ingredient").forGetter(AdvancedFluidIngredient::getAdvancedIngredient)).apply((Applicative)instance, AdvancedFluidIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AdvancedFluidIngredient> STREAM_CODEC = StreamCodec.composite(FluidAdvancedIngredient.STREAM_CODEC, AdvancedFluidIngredient::getAdvancedIngredient, AdvancedFluidIngredient::new);
    protected final IAdvancedIngredient<? super FluidStack> advancedIngredient;

    public AdvancedFluidIngredient(IAdvancedIngredient<? super FluidStack> ingredient) {
        this.advancedIngredient = ingredient;
    }

    public IAdvancedIngredient<? super FluidStack> getAdvancedIngredient() {
        return this.advancedIngredient;
    }

    public boolean test(FluidStack stack) {
        return this.advancedIngredient.test(stack);
    }

    protected Stream<FluidStack> generateStacks() {
        return this.advancedIngredient.streamExamples().map(s -> {
            FluidStack fluidStack;
            return s instanceof FluidStack ? (fluidStack = (FluidStack)s) : null;
        });
    }

    public boolean isSimple() {
        return false;
    }

    public FluidIngredientType<?> getType() {
        return (FluidIngredientType)PetrolparkIngredientTypes.FLUID_ADVANCED.get();
    }

    public int hashCode() {
        return 31 * this.advancedIngredient.hashCode();
    }

    public boolean equals(Object obj) {
        AdvancedFluidIngredient ingredient;
        if (obj == this) {
            return true;
        }
        return obj instanceof AdvancedFluidIngredient && ingredient.advancedIngredient.equals((Object)(ingredient = (AdvancedFluidIngredient)((Object)obj)));
    }
}

