/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient;

import com.mojang.serialization.MapCodec;
import com.petrolpark.util.CodecHelper;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public record BlockHolderSetIngredient(HolderSet<Block> blocks) implements ICustomIngredient
{
    public static final MapCodec<BlockHolderSetIngredient> CODEC = CodecHelper.singleFieldMap(RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK), "blocks", BlockHolderSetIngredient::blocks, BlockHolderSetIngredient::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockHolderSetIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.BLOCK), BlockHolderSetIngredient::blocks, BlockHolderSetIngredient::new);

    public boolean test(@Nonnull ItemStack stack) {
        return this.blocks.stream().map(Holder::value).map(Block::asItem).anyMatch(arg_0 -> ((ItemStack)stack).is(arg_0));
    }

    public Stream<ItemStack> getItems() {
        return this.blocks.stream().map(Holder::value).map(Block::asItem).map(ItemStack::new);
    }

    public boolean isSimple() {
        return true;
    }

    public IngredientType<?> getType() {
        throw new UnsupportedOperationException("Unimplemented method 'getType'");
    }
}

