/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

@Deprecated
public interface BlockIngredient<T extends BlockIngredient<T>> {
    public static final ImpossibleBlockIngredient IMPOSSIBLE = new ImpossibleBlockIngredient();

    public BlockIngredientType<T> getType();

    public boolean isValid(BlockState var1);

    public NonNullList<ItemStack> getDisplayedItemStacks();

    public void write(FriendlyByteBuf var1);

    public static void registerType(BlockIngredientType<?> type) {
        Registry.TYPES.put(type.getId(), type);
    }

    public static void write(BlockIngredient<?> ingredient, FriendlyByteBuf buffer) {
        ResourceLocation typeId = ingredient.getType().getId();
        if (!Registry.TYPES.containsKey(typeId)) {
            throw new IllegalStateException("Block Ingredient Type " + String.valueOf(typeId) + " is not registered.");
        }
        buffer.writeResourceLocation(typeId);
        ingredient.write(buffer);
    }

    public static BlockIngredient<?> read(FriendlyByteBuf buffer) {
        return Registry.TYPES.get(buffer.readResourceLocation()).read(buffer);
    }

    public static class Registry {
        private static Map<ResourceLocation, BlockIngredientType<?>> TYPES = new HashMap();

        static {
            BlockIngredient.registerType(ImpossibleBlockIngredient.TYPE);
            BlockIngredient.registerType(BlockTagIngredient.TYPE);
            BlockIngredient.registerType(UnionBlockIngredient.TYPE);
            BlockIngredient.registerType(IntersectionBlockIngredient.TYPE);
        }
    }

    public static interface BlockIngredientType<T extends BlockIngredient<T>> {
        public T read(FriendlyByteBuf var1);

        public ResourceLocation getId();
    }

    public static class ImpossibleBlockIngredient
    implements BlockIngredient<ImpossibleBlockIngredient> {
        public static final Type TYPE = new Type();

        @Override
        public BlockIngredientType<ImpossibleBlockIngredient> getType() {
            return TYPE;
        }

        @Override
        public boolean isValid(BlockState state) {
            return false;
        }

        @Override
        public NonNullList<ItemStack> getDisplayedItemStacks() {
            return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[0]);
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
        }

        protected static class Type
        implements BlockIngredientType<ImpossibleBlockIngredient> {
            public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"petrolpark", (String)"impossible");

            protected Type() {
            }

            @Override
            public ImpossibleBlockIngredient read(FriendlyByteBuf buffer) {
                return IMPOSSIBLE;
            }

            @Override
            public ResourceLocation getId() {
                return ID;
            }
        }
    }

    public static class IntersectionBlockIngredient
    extends SetBlockIngredient<IntersectionBlockIngredient> {
        public static final Type TYPE = new Type();

        public IntersectionBlockIngredient(BlockIngredient<?>[] values) {
            super(values);
        }

        @Override
        public BlockIngredientType<IntersectionBlockIngredient> getType() {
            return TYPE;
        }

        @Override
        public boolean isValid(BlockState state) {
            return Stream.of(this.values).allMatch(i -> i.isValid(state));
        }

        @Override
        public NonNullList<ItemStack> getDisplayedItemStacks() {
            if (this.values.length == 0) {
                return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[0]);
            }
            Optional<BlockIngredient> ingredient = Stream.of(this.values).filter(i -> !i.getDisplayedItemStacks().isEmpty()).findFirst();
            if (ingredient.isEmpty()) {
                return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[0]);
            }
            return NonNullList.of((Object)ItemStack.EMPTY, (Object[])((ItemStack[])ingredient.get().getDisplayedItemStacks().stream().filter(stack -> Stream.of(this.values).allMatch(i -> i.getDisplayedItemStacks().isEmpty() || i.getDisplayedItemStacks().contains(stack))).toArray(ItemStack[]::new)));
        }

        protected static class Type
        extends SetBlockIngredient.SetBlockIngredientType<IntersectionBlockIngredient> {
            public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"petrolpark", (String)"intersection");

            protected Type() {
            }

            @Override
            public ResourceLocation getId() {
                return ID;
            }

            @Override
            protected IntersectionBlockIngredient create(BlockIngredient<?>[] values) {
                return new IntersectionBlockIngredient(values);
            }
        }
    }

    public static class UnionBlockIngredient
    extends SetBlockIngredient<UnionBlockIngredient> {
        public static final Type TYPE = new Type();

        public UnionBlockIngredient(BlockIngredient<?>[] values) {
            super(values);
        }

        @Override
        public BlockIngredientType<UnionBlockIngredient> getType() {
            return TYPE;
        }

        @Override
        public boolean isValid(BlockState state) {
            return Stream.of(this.values).anyMatch(i -> i.isValid(state));
        }

        @Override
        public NonNullList<ItemStack> getDisplayedItemStacks() {
            HashSet<ItemStack> items = new HashSet<ItemStack>();
            for (BlockIngredient i : this.values) {
                items.addAll((Collection<ItemStack>)i.getDisplayedItemStacks());
            }
            return NonNullList.of((Object)ItemStack.EMPTY, (Object[])((ItemStack[])items.toArray(ItemStack[]::new)));
        }

        protected static class Type
        extends SetBlockIngredient.SetBlockIngredientType<UnionBlockIngredient> {
            public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"petrolpark", (String)"union");

            protected Type() {
            }

            @Override
            public ResourceLocation getId() {
                return ID;
            }

            @Override
            protected UnionBlockIngredient create(BlockIngredient<?>[] values) {
                return new UnionBlockIngredient(values);
            }
        }
    }

    public static abstract class SetBlockIngredient<T extends BlockIngredient<T>>
    implements BlockIngredient<T> {
        public final BlockIngredient<?>[] values;

        public SetBlockIngredient(BlockIngredient<?>[] values) {
            this.values = values;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeVarInt(this.values.length);
            for (BlockIngredient<?> i : this.values) {
                i.write(buffer);
            }
        }

        protected static abstract class SetBlockIngredientType<T extends BlockIngredient<T>>
        implements BlockIngredientType<T> {
            protected SetBlockIngredientType() {
            }

            @Override
            public T read(FriendlyByteBuf buffer) {
                int length = buffer.readVarInt();
                BlockIngredient[] values = new BlockIngredient[length];
                for (int i = 0; i < length; ++i) {
                    values[i] = BlockIngredient.read(buffer);
                }
                return this.create(values);
            }

            protected abstract T create(BlockIngredient<?>[] var1);
        }
    }

    public static class BlockTagIngredient
    implements BlockIngredient<BlockTagIngredient> {
        public static final Type TYPE = new Type();
        public final TagKey<Block> tag;

        public BlockTagIngredient(TagKey<Block> tag) {
            this.tag = tag;
        }

        @Override
        public BlockIngredientType<BlockTagIngredient> getType() {
            return TYPE;
        }

        @Override
        public boolean isValid(BlockState state) {
            return state.is(this.tag);
        }

        @Override
        public NonNullList<ItemStack> getDisplayedItemStacks() {
            return NonNullList.of((Object)ItemStack.EMPTY, (Object[])BuiltInRegistries.BLOCK.getTag(this.tag).map(set -> (ItemStack[])set.stream().map(Holder::value).map(ItemStack::new).toArray(ItemStack[]::new)).orElse(new ItemStack[0]));
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeResourceLocation(this.tag.location());
        }

        protected static class Type
        implements BlockIngredientType<BlockTagIngredient> {
            public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"petrolpark", (String)"block_tag");

            protected Type() {
            }

            @Override
            public BlockTagIngredient read(FriendlyByteBuf buffer) {
                return new BlockTagIngredient((TagKey<Block>)BlockTags.create((ResourceLocation)buffer.readResourceLocation()));
            }

            @Override
            public ResourceLocation getId() {
                return ID;
            }
        }
    }
}

