/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient.advanced;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkAdvancedIngredientTypes;
import com.petrolpark.core.recipe.ingredient.advanced.GenericAdvancedIngredientType;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.IForcingItemAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.ITypelessAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.TypeAttachedAdvancedIngredient;
import com.petrolpark.util.Lang;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;

public record CompoundAdvancedIngredient<STACK>(List<IAdvancedIngredient<? super STACK>> ingredients, int required) implements ITypelessAdvancedIngredient<STACK>,
IForcingItemAdvancedIngredient
{
    public static final <STACK> MapCodec<CompoundAdvancedIngredient<STACK>> codec(Codec<IAdvancedIngredient<? super STACK>> typeCodec) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)typeCodec.listOf().fieldOf("ingredients").forGetter(CompoundAdvancedIngredient::ingredients), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("proportion", (Object)1).forGetter(CompoundAdvancedIngredient::required)).apply((Applicative)instance, CompoundAdvancedIngredient::new));
    }

    public static final <STACK> StreamCodec<RegistryFriendlyByteBuf, CompoundAdvancedIngredient<STACK>> streamCodec(StreamCodec<RegistryFriendlyByteBuf, IAdvancedIngredient<? super STACK>> typeStreamCodec) {
        return StreamCodec.composite((StreamCodec)typeStreamCodec.apply(ByteBufCodecs.list()), CompoundAdvancedIngredient::ingredients, (StreamCodec)ByteBufCodecs.INT, CompoundAdvancedIngredient::required, CompoundAdvancedIngredient::new);
    }

    protected static final <STACK> CompoundAdvancedIngredient<STACK> typelessAnd(List<IAdvancedIngredient<? super STACK>> ingredients) {
        return new CompoundAdvancedIngredient<STACK>(ingredients, ingredients.size());
    }

    protected static final <STACK> CompoundAdvancedIngredient<STACK> typelessOr(List<IAdvancedIngredient<? super STACK>> ingredients) {
        return new CompoundAdvancedIngredient<STACK>(ingredients, 1);
    }

    public static final IAdvancedIngredient<ItemStack> and(List<IAdvancedIngredient<? super ItemStack>> ingredients) {
        return ((GenericAdvancedIngredientType)PetrolparkAdvancedIngredientTypes.ITEM_COMPOUND.get()).create(CompoundAdvancedIngredient.typelessAnd(ingredients));
    }

    public static final IAdvancedIngredient<ItemStack> or(List<IAdvancedIngredient<? super ItemStack>> ingredients) {
        return ((GenericAdvancedIngredientType)PetrolparkAdvancedIngredientTypes.ITEM_COMPOUND.get()).create(CompoundAdvancedIngredient.typelessOr(ingredients));
    }

    @Override
    public boolean test(STACK stack) {
        if (this.isImpossible()) {
            return false;
        }
        int fulfilled = 0;
        int unfulfilled = 0;
        for (IAdvancedIngredient<STACK> ingredient : this.ingredients()) {
            if (ingredient.test(stack)) {
                ++fulfilled;
            } else {
                ++unfulfilled;
            }
            if (unfulfilled >= this.ingredients().size() - this.required()) {
                return false;
            }
            if (fulfilled < this.required) continue;
            return true;
        }
        return false;
    }

    @Override
    public Stream<? extends STACK> streamExamples() {
        if (this.isImpossible()) {
            return Stream.empty();
        }
        Stream<Object> stream = this.ingredients().stream().flatMap(ITypelessAdvancedIngredient::streamExamples).map(this::checkedCast);
        for (IAdvancedIngredient<STACK> ingredient : this.ingredients()) {
            stream = this.modifyExamples(stream, ingredient);
        }
        return stream.filter(this::test);
    }

    @Override
    public Stream<? extends STACK> streamCounterExamples() {
        if (this.isImpossible()) {
            return Stream.empty();
        }
        Stream<Object> stream = this.ingredients().stream().flatMap(ITypelessAdvancedIngredient::streamCounterExamples).map(this::checkedCast);
        for (IAdvancedIngredient<STACK> ingredient : this.ingredients()) {
            stream = this.modifyCounterExamples(stream, ingredient);
        }
        return stream.filter(Predicate.not(this::test));
    }

    @Override
    public Stream<STACK> modifyExamples(Stream<STACK> exampleStacks) {
        if (this.isImpossible()) {
            return Stream.empty();
        }
        for (IAdvancedIngredient<STACK> ingredient : this.ingredients()) {
            exampleStacks = this.modifyExamples(exampleStacks, ingredient);
        }
        return exampleStacks;
    }

    protected <STACK_PARENT> Stream<STACK> modifyExamples(Stream<STACK> exampleStacks, IAdvancedIngredient<STACK_PARENT> ingredient) {
        return ingredient.modifyExamples(exampleStacks.map(ingredient::checkedCast)).map(this::checkedCast);
    }

    @Override
    public Stream<STACK> modifyCounterExamples(Stream<STACK> counterExampleStacks) {
        if (this.isImpossible()) {
            return counterExampleStacks;
        }
        for (IAdvancedIngredient<STACK> ingredient : this.ingredients()) {
            counterExampleStacks = this.modifyCounterExamples(counterExampleStacks, ingredient);
        }
        return counterExampleStacks;
    }

    protected <STACK_PARENT> Stream<STACK> modifyCounterExamples(Stream<STACK> exampleStacks, IAdvancedIngredient<STACK_PARENT> ingredient) {
        return ingredient.modifyCounterExamples(exampleStacks.map(ingredient::checkedCast)).map(this::checkedCast);
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder description) {
        if (this.isOr()) {
            description.add(this.translate("any", new Object[0]));
        } else if (this.isAnd()) {
            description.add(this.translate("all", new Object[0]));
        } else {
            description.add(this.translate("at_least", this.required()));
        }
        description.indent();
        this.ingredients().forEach(ingredient -> ingredient.addToDescription(description));
        description.unindent();
    }

    @Override
    public void addToCounterDescription(Lang.IndentedTooltipBuilder description) {
        if (this.isOr()) {
            description.add(this.translate("none", new Object[0]));
        } else {
            description.add(this.translate("at_most", this.required() - 1));
        }
        description.indent();
        this.ingredients().forEach(ingredient -> ingredient.addToDescription(description));
        description.unindent();
    }

    @Override
    @Nonnull
    public Optional<ItemStack> forceLootItemFunction(LootItemFunction function, LootContext context, ItemStack stack) {
        boolean forced = false;
        ItemStack forcedStack = stack;
        for (IAdvancedIngredient<STACK> ingredient : this.ingredients()) {
            IForcingItemAdvancedIngredient functionForcingIngredient;
            Optional<ItemStack> forcedStackOp;
            if (!(ingredient instanceof IForcingItemAdvancedIngredient) || !(forcedStackOp = (functionForcingIngredient = (IForcingItemAdvancedIngredient)((Object)ingredient)).forceLootItemFunction(function, context, forcedStack)).isPresent()) continue;
            forced = true;
            forcedStack = forcedStackOp.get();
        }
        return forced ? Optional.of(forcedStack) : Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<ItemStack> forbidLootItemFunction(LootItemFunction function, LootContext context, ItemStack stack) {
        boolean forbidden = false;
        ItemStack forbiddenStack = stack;
        for (IAdvancedIngredient<STACK> ingredient : this.ingredients()) {
            IForcingItemAdvancedIngredient functionForcingIngredient;
            Optional<ItemStack> forbiddenStackOp;
            if (!(ingredient instanceof IForcingItemAdvancedIngredient) || !(forbiddenStackOp = (functionForcingIngredient = (IForcingItemAdvancedIngredient)((Object)ingredient)).forbidLootItemFunction(function, context, forbiddenStack)).isPresent()) continue;
            forbidden = true;
            forbiddenStack = forbiddenStackOp.get();
        }
        return forbidden ? Optional.of(forbiddenStack) : Optional.empty();
    }

    @Override
    @Nullable
    public Optional<MerchantOffer> forceTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        for (IAdvancedIngredient<STACK> ingredient : this.ingredients()) {
            IForcingItemAdvancedIngredient functionForcingIngredient;
            Optional<MerchantOffer> forcedOffer;
            if (!(ingredient instanceof IForcingItemAdvancedIngredient) || (forcedOffer = (functionForcingIngredient = (IForcingItemAdvancedIngredient)((Object)ingredient)).forceTradeListing(tradeListing, trader, random)) == null) continue;
            return forcedOffer;
        }
        return null;
    }

    @Override
    @Nullable
    public Optional<MerchantOffer> forbidTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        for (IAdvancedIngredient<STACK> ingredient : this.ingredients()) {
            IForcingItemAdvancedIngredient functionForcingIngredient;
            Optional<MerchantOffer> forbiddenOffer;
            if (!(ingredient instanceof IForcingItemAdvancedIngredient) || (forbiddenOffer = (functionForcingIngredient = (IForcingItemAdvancedIngredient)((Object)ingredient)).forbidTradeListing(tradeListing, trader, random)) == null) continue;
            return forbiddenOffer;
        }
        return null;
    }

    @Override
    public ITypelessAdvancedIngredient<? super STACK> simplify() {
        if (this.ingredients().size() == 1) {
            return this.ingredients().get(0).simplify();
        }
        this.ingredients().replaceAll(IAdvancedIngredient::simplify);
        if (this.isAnd() || this.isOr()) {
            Iterator<IAdvancedIngredient<STACK>> iterator = this.ingredients().iterator();
            while (iterator.hasNext()) {
                this.cast(iterator.next()).ifPresent(compoundIngredient -> {
                    if (compoundIngredient.isAnd() == this.isAnd() || compoundIngredient.isOr() == this.isOr()) {
                        this.ingredients().addAll(compoundIngredient.ingredients());
                        iterator.remove();
                    }
                });
            }
        }
        return this;
    }

    public boolean isImpossible() {
        return this.required() > this.ingredients().size();
    }

    public boolean isOr() {
        return this.required() == 1;
    }

    public boolean isAnd() {
        return this.required() == this.ingredients().size();
    }

    protected Optional<CompoundAdvancedIngredient<? super STACK>> cast(IAdvancedIngredient<? super STACK> ingredient) {
        TypeAttachedAdvancedIngredient typedIngredient;
        Object INGREDIENT;
        if (ingredient instanceof TypeAttachedAdvancedIngredient && (INGREDIENT = (typedIngredient = (TypeAttachedAdvancedIngredient)ingredient).untypedIngredient()) instanceof CompoundAdvancedIngredient) {
            CompoundAdvancedIngredient compoundIngredient = (CompoundAdvancedIngredient)INGREDIENT;
            return Optional.of(compoundIngredient);
        }
        return Optional.empty();
    }

    protected Component translate(String keyPostfix, Object ... args) {
        return Component.translatable((String)("petrolpark.advanced_ingredient.compound." + keyPostfix), (Object[])args);
    }
}

