/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient.advanced;

import com.mojang.serialization.MapCodec;
import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.create.CreateAdvancedIngredientTypes;
import com.petrolpark.compat.create.CreateTags;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.INamedAdvancedIngredientType;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

@RequiresCreate
public record CreateItemAttributeAdvancedIngredient(ItemAttribute attribute) implements IAdvancedIngredient<ItemStack>
{
    public static final MapCodec<CreateItemAttributeAdvancedIngredient> CODEC = CodecHelper.singleFieldMap(ItemAttribute.CODEC, "attribute", CreateItemAttributeAdvancedIngredient::attribute, CreateItemAttributeAdvancedIngredient::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, CreateItemAttributeAdvancedIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemAttribute.STREAM_CODEC, CreateItemAttributeAdvancedIngredient::attribute, CreateItemAttributeAdvancedIngredient::new);

    @Override
    public boolean test(ItemStack stack) {
        try {
            return this.attribute.appliesTo(stack, null);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder description) {
        description.add((Component)this.attribute().format(false));
    }

    @Override
    public void addToCounterDescription(Lang.IndentedTooltipBuilder description) {
        description.add((Component)this.attribute().format(true));
    }

    @Override
    public INamedAdvancedIngredientType<ItemStack> getType() {
        return (INamedAdvancedIngredientType)CreateAdvancedIngredientTypes.ITEM_ATTRIBUTE.get();
    }

    public record Type(String translationKey) implements INamedAdvancedIngredientType<ItemStack>
    {
        @Override
        public MapCodec<CreateItemAttributeAdvancedIngredient> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, CreateItemAttributeAdvancedIngredient> streamCodec() {
            return STREAM_CODEC;
        }

        @Override
        public Stream<CreateItemAttributeAdvancedIngredient> streamApplicableIngredients(Level level, ItemStack stack) {
            return level.registryAccess().lookupOrThrow(CreateRegistries.ITEM_ATTRIBUTE_TYPE).getOrThrow(CreateTags.ItemAttributes.LEVEL_INDEPDENDENT.tag).stream().filter(CreateTags.ItemAttributes.NOT_FOR_INGREDIENTS::matches).map(Holder::value).flatMap(iat -> iat.getAllAttributes(stack, level).stream()).map(CreateItemAttributeAdvancedIngredient::new);
        }
    }
}

