/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient.advanced;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkAdvancedIngredientTypes;
import com.petrolpark.core.recipe.ingredient.advanced.INamedAdvancedIngredientType;
import com.petrolpark.core.recipe.ingredient.advanced.ItemAdvancedIngredient;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import io.netty.buffer.ByteBuf;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record ItemIDRegExAdvancedIngredient(String idRegEx) implements ItemAdvancedIngredient
{
    public static final MapCodec<ItemIDRegExAdvancedIngredient> CODEC = CodecHelper.singleFieldMap(Codec.STRING, "regex", ItemIDRegExAdvancedIngredient::idRegEx, ItemIDRegExAdvancedIngredient::new);
    public static final StreamCodec<ByteBuf, ItemIDRegExAdvancedIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ItemIDRegExAdvancedIngredient::idRegEx, ItemIDRegExAdvancedIngredient::new);

    @Override
    public Stream<? extends ItemStack> streamExamples() {
        return BuiltInRegistries.ITEM.stream().filter(this::test).map(ItemStack::new);
    }

    @Override
    public Stream<? extends ItemStack> streamCounterExamples() {
        return BuiltInRegistries.ITEM.stream().dropWhile(this::test).map(ItemStack::new);
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder description) {
        description.add(this.translate(this.idRegEx(), new Object[0]));
    }

    @Override
    public void addToCounterDescription(Lang.IndentedTooltipBuilder description) {
        description.add(this.translateInverse(this.idRegEx()));
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.test(stack.getItem());
    }

    @Override
    public boolean test(Item item) {
        return Pattern.matches(this.idRegEx, BuiltInRegistries.ITEM.getKey((Object)item).getPath());
    }

    @Override
    public INamedAdvancedIngredientType<ItemStack> getType() {
        return (INamedAdvancedIngredientType)PetrolparkAdvancedIngredientTypes.ITEM_ID_REGEX.get();
    }
}

