/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient.advanced;

import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkAdvancedIngredientTypes;
import com.petrolpark.core.recipe.ingredient.advanced.INamedAdvancedIngredientType;
import com.petrolpark.core.recipe.ingredient.advanced.ItemAdvancedIngredient;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public record ItemItemAdvancedIngredient(Item item) implements ItemAdvancedIngredient
{
    public static final MapCodec<ItemItemAdvancedIngredient> CODEC = CodecHelper.singleFieldMap(BuiltInRegistries.ITEM.byNameCodec(), "id", ItemItemAdvancedIngredient::item, ItemItemAdvancedIngredient::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemItemAdvancedIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), ItemItemAdvancedIngredient::item, ItemItemAdvancedIngredient::new);

    @Override
    public boolean test(ItemStack stack) {
        return stack.is(this.item());
    }

    @Override
    public Stream<ItemStack> streamExamples() {
        return Stream.of(new ItemStack((ItemLike)this.item()));
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder description) {
        description.add(this.item().getDescription());
    }

    @Override
    public void addToCounterDescription(Lang.IndentedTooltipBuilder description) {
        description.add(this.translateInverse(this.item().getDescription()));
    }

    @Override
    public INamedAdvancedIngredientType<ItemStack> getType() {
        return (INamedAdvancedIngredientType)PetrolparkAdvancedIngredientTypes.ITEM.get();
    }

    public record Type(String translationKey) implements INamedAdvancedIngredientType<ItemStack>
    {
        @Override
        public MapCodec<ItemItemAdvancedIngredient> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ItemItemAdvancedIngredient> streamCodec() {
            return STREAM_CODEC;
        }

        @Override
        public Stream<ItemItemAdvancedIngredient> streamApplicableIngredients(Level level, ItemStack stack) {
            return Stream.of(new ItemItemAdvancedIngredient(stack.getItem()));
        }
    }
}

