/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient.editor;

import com.petrolpark.core.recipe.ingredient.AdvancedItemIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.CompoundAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.ItemItemAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.NotAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.TagItemAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.TypeAttachedAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.editor.INeoForgeIngredientConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IntersectionIngredient;

public class ItemIngredientConverter
implements INeoForgeIngredientConverter<ItemStack, Ingredient> {
    @Override
    public Ingredient convertToNeoForgeIngredient(IAdvancedIngredient<? super ItemStack> advancedIngredient) throws INeoForgeIngredientConverter.IngredientConversionException {
        TypeAttachedAdvancedIngredient typedAdvancedIngredient;
        Object INGREDIENT;
        if (advancedIngredient instanceof TypeAttachedAdvancedIngredient && (INGREDIENT = (typedAdvancedIngredient = (TypeAttachedAdvancedIngredient)advancedIngredient).untypedIngredient()) instanceof CompoundAdvancedIngredient) {
            CompoundAdvancedIngredient compoundAdvancedIngredient;
            CompoundAdvancedIngredient untypedAdvancedIngredient = (CompoundAdvancedIngredient)INGREDIENT;
            try {
                compoundAdvancedIngredient = untypedAdvancedIngredient;
            }
            catch (ClassCastException e) {
                throw new INeoForgeIngredientConverter.IngredientConversionException("Could not cast the Compound Ingredient type");
            }
            if (!compoundAdvancedIngredient.isAnd() && !compoundAdvancedIngredient.isOr()) {
                throw new INeoForgeIngredientConverter.IngredientConversionException("Compound Ingredient AdvancedIngredients may only require any or all child AdvancedIngredients");
            }
            ArrayList childAdvancedIngredients = new ArrayList();
            ArrayList nottedChildAdvancedIngredients = new ArrayList();
            ArrayList vanillaIngredientValues = new ArrayList();
            ArrayList<Ingredient.Value> nottedVanillaIngredientValues = new ArrayList<Ingredient.Value>();
            for (IAdvancedIngredient<Object> childAdvancedIngredient : compoundAdvancedIngredient.ingredients()) {
                Object valueOp;
                Optional<IAdvancedIngredient<? super ItemStack>> notOp = this.getNot(childAdvancedIngredient);
                boolean not = notOp.isPresent();
                if (not) {
                    childAdvancedIngredient = notOp.get();
                }
                if (((Optional)(valueOp = this.getVanillaIngredientValue(childAdvancedIngredient))).isPresent()) {
                    (not ? nottedVanillaIngredientValues : vanillaIngredientValues).add(((Optional)valueOp).get());
                    continue;
                }
                (not ? nottedChildAdvancedIngredients : childAdvancedIngredients).add(childAdvancedIngredient);
            }
            Ingredient vanillaIngredient = nottedVanillaIngredientValues.isEmpty() ? Ingredient.fromValues(vanillaIngredientValues.stream()) : DifferenceIngredient.of((Ingredient)Ingredient.fromValues(vanillaIngredientValues.stream()), (Ingredient)(compoundAdvancedIngredient.isAnd() ? Ingredient.fromValues(nottedVanillaIngredientValues.stream()) : IntersectionIngredient.of((Ingredient[])((Ingredient[])nottedVanillaIngredientValues.stream().map(Stream::of).map(Ingredient::fromValues).toArray(Ingredient[]::new)))));
            if (childAdvancedIngredients.isEmpty() && nottedChildAdvancedIngredients.isEmpty()) {
                if (vanillaIngredientValues.isEmpty()) {
                    throw new INeoForgeIngredientConverter.IngredientConversionException("Cannot have only 'not' values in a Compound");
                }
                return vanillaIngredient;
            }
            if (childAdvancedIngredients.isEmpty()) {
                throw new INeoForgeIngredientConverter.IngredientConversionException("Cannot have only 'not' Ingredient AdvancedIngredients in a Compound");
            }
            ArrayList<Ingredient> yesIngredients = new ArrayList<Ingredient>(childAdvancedIngredients.size() + (vanillaIngredient.isEmpty() ? 0 : 1));
            if (!vanillaIngredient.isEmpty()) {
                yesIngredients.add(vanillaIngredient);
            }
            for (IAdvancedIngredient childAdvancedIngredient : childAdvancedIngredients) {
                yesIngredients.add(this.convertToNeoForgeIngredient((IAdvancedIngredient<? super ItemStack>)childAdvancedIngredient));
            }
            Ingredient yesIngredient = ((ICustomIngredient)(compoundAdvancedIngredient.isOr() ? new CompoundIngredient(yesIngredients) : new IntersectionIngredient(yesIngredients))).toVanilla();
            if (nottedChildAdvancedIngredients.isEmpty()) {
                return yesIngredient;
            }
            ArrayList<Ingredient> noIngredients = new ArrayList<Ingredient>(nottedChildAdvancedIngredients.size());
            for (IAdvancedIngredient iAdvancedIngredient : nottedChildAdvancedIngredients) {
                noIngredients.add(this.convertToNeoForgeIngredient((IAdvancedIngredient<? super ItemStack>)iAdvancedIngredient));
            }
            Ingredient noIngredient = ((ICustomIngredient)(compoundAdvancedIngredient.isOr() ? new IntersectionIngredient(noIngredients) : new CompoundIngredient(noIngredients))).toVanilla();
            return DifferenceIngredient.of((Ingredient)yesIngredient, (Ingredient)noIngredient);
        }
        Optional<Ingredient.Value> valueOp = this.getVanillaIngredientValue(advancedIngredient);
        if (valueOp.isPresent()) {
            return Ingredient.fromValues(valueOp.stream());
        }
        throw new INeoForgeIngredientConverter.IngredientConversionException("todo");
    }

    protected Optional<Ingredient.Value> getVanillaIngredientValue(IAdvancedIngredient<? super ItemStack> advancedIngredient) {
        if (advancedIngredient instanceof ItemItemAdvancedIngredient) {
            ItemItemAdvancedIngredient itemIIM = (ItemItemAdvancedIngredient)advancedIngredient;
            return Optional.of(new Ingredient.ItemValue(new ItemStack((ItemLike)itemIIM.item())));
        }
        if (advancedIngredient instanceof TagItemAdvancedIngredient) {
            TagItemAdvancedIngredient tagIIM = (TagItemAdvancedIngredient)advancedIngredient;
            return Optional.of(new Ingredient.TagValue(tagIIM.tag()));
        }
        return Optional.empty();
    }

    protected Optional<IAdvancedIngredient<? super ItemStack>> getNot(IAdvancedIngredient<? super ItemStack> potentialNotAdvancedIngredient) {
        TypeAttachedAdvancedIngredient typedAdvancedIngredient;
        Object INGREDIENT;
        if (potentialNotAdvancedIngredient instanceof TypeAttachedAdvancedIngredient && (INGREDIENT = (typedAdvancedIngredient = (TypeAttachedAdvancedIngredient)potentialNotAdvancedIngredient).untypedIngredient()) instanceof NotAdvancedIngredient) {
            NotAdvancedIngredient untypedAdvancedIngredient = (NotAdvancedIngredient)INGREDIENT;
            try {
                return Optional.of(untypedAdvancedIngredient.ingredient());
            }
            catch (ClassCastException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public IAdvancedIngredient<? super ItemStack> convertToAdvancedIngredient(Ingredient ingredient) throws INeoForgeIngredientConverter.IngredientConversionException {
        if (ingredient.isCustom()) {
            Object advancedIngredients;
            ICustomIngredient iCustomIngredient = ingredient.getCustomIngredient();
            if (iCustomIngredient instanceof AdvancedItemIngredient) {
                AdvancedItemIngredient modifiedIngredient = (AdvancedItemIngredient)iCustomIngredient;
                return modifiedIngredient.advacnedIngredient().simplify();
            }
            iCustomIngredient = ingredient.getCustomIngredient();
            if (iCustomIngredient instanceof CompoundIngredient) {
                CompoundIngredient compoundIngredient = (CompoundIngredient)iCustomIngredient;
                advancedIngredients = new ArrayList(compoundIngredient.children().size());
                for (Ingredient child : compoundIngredient.children()) {
                    advancedIngredients.add(this.convertToAdvancedIngredient(child));
                }
                return CompoundAdvancedIngredient.or((List<IAdvancedIngredient<? super ItemStack>>)advancedIngredients).simplify();
            }
            advancedIngredients = ingredient.getCustomIngredient();
            if (advancedIngredients instanceof IntersectionIngredient) {
                IntersectionIngredient intersectionIngredient = (IntersectionIngredient)advancedIngredients;
                advancedIngredients = new ArrayList(intersectionIngredient.children().size());
                for (Ingredient child : intersectionIngredient.children()) {
                    advancedIngredients.add(this.convertToAdvancedIngredient(child));
                }
                return CompoundAdvancedIngredient.and((List<IAdvancedIngredient<? super ItemStack>>)advancedIngredients).simplify();
            }
            advancedIngredients = ingredient.getCustomIngredient();
            if (advancedIngredients instanceof DifferenceIngredient) {
                DifferenceIngredient differenceIngredient = (DifferenceIngredient)advancedIngredients;
                advancedIngredients = new ArrayList(2);
                advancedIngredients.add(this.convertToAdvancedIngredient(differenceIngredient.base()));
                advancedIngredients.add(NotAdvancedIngredient.of(this.convertToAdvancedIngredient(differenceIngredient.subtracted())));
                return CompoundAdvancedIngredient.and((List<IAdvancedIngredient<? super ItemStack>>)advancedIngredients).simplify();
            }
            throw new INeoForgeIngredientConverter.IngredientConversionException("Cannot convert Custom Ingredient to Petrolpark Modified Ingredient");
        }
        if (ingredient.isSimple()) {
            ArrayList<IAdvancedIngredient<? super ItemStack>> advancedIngredients = new ArrayList<IAdvancedIngredient<? super ItemStack>>(ingredient.getValues().length);
            for (Ingredient.Value value : ingredient.getValues()) {
                if (value instanceof Ingredient.ItemValue) {
                    Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
                    advancedIngredients.add(new ItemItemAdvancedIngredient(itemValue.item().getItem()));
                    continue;
                }
                if (!(value instanceof Ingredient.TagValue)) continue;
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                advancedIngredients.add(new TagItemAdvancedIngredient((TagKey<Item>)tagValue.tag()));
            }
            if (advancedIngredients.size() == 1) {
                return (IAdvancedIngredient)advancedIngredients.get(0);
            }
            return CompoundAdvancedIngredient.or(advancedIngredients);
        }
        throw new INeoForgeIngredientConverter.IngredientConversionException("Unknown problem");
    }
}

