/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.recycling;

import com.petrolpark.PetrolparkRecipeTypes;
import com.petrolpark.PetrolparkTags;
import com.petrolpark.core.recipe.recycling.IRecyclableCustomIngredient;
import com.petrolpark.core.recipe.recycling.IRecyclingRecipe;
import com.petrolpark.core.recipe.recycling.RecyclingOutputs;
import com.petrolpark.core.recipe.recycling.RecyclingOutputsModifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;

@EventBusSubscriber
public class RecyclingManager {
    protected static final Map<Ingredient, RecyclingOutputs> INGREDIENT_INVERSES = new HashMap<Ingredient, RecyclingOutputs>();
    protected static final Map<Item, RecyclingOutputs> ITEM_RECYCLINGS = new HashMap<Item, RecyclingOutputs>();
    protected static final Set<RecyclingOutputsModifier> OUTPUT_MODIFIERS = new TreeSet<RecyclingOutputsModifier>(RecyclingOutputsModifier::compare);

    public static final void registerModifier(RecyclingOutputsModifier recyclingOutputsModifier) {
        OUTPUT_MODIFIERS.add(recyclingOutputsModifier);
    }

    public static final void loadIngredientInverses(RecipeManager recipeManager) {
        recipeManager.getAllRecipesFor((RecipeType)PetrolparkRecipeTypes.INGREDIENT_RECYCLING.get()).stream().map(RecipeHolder::value).forEach(recipe -> INGREDIENT_INVERSES.put(recipe.ingredient(), recipe.outputs()));
    }

    public static final RecyclingOutputs getInverse(Ingredient ingredient) {
        return INGREDIENT_INVERSES.computeIfAbsent(ingredient, i -> {
            ICustomIngredient patt0$temp;
            if (i.isCustom() && (patt0$temp = i.getCustomIngredient()) instanceof IRecyclableCustomIngredient) {
                IRecyclableCustomIngredient recyclable = (IRecyclableCustomIngredient)patt0$temp;
                return recyclable.getRecyclingOutputs();
            }
            if (!i.isSimple()) {
                return RecyclingOutputs.empty();
            }
            ItemStack[] values = i.getItems();
            if (values.length == 1) {
                return new RecyclingOutputs(values[0]);
            }
            return RecyclingOutputs.empty();
        });
    }

    public static final RecyclingOutputs getInverseRecipeRecyclingOutputs(Level level, Item item) {
        List<RecyclingOutputs> possibleOutputs = level.getRecipeManager().getRecipes().stream().map(RecipeHolder::value).filter(PetrolparkTags.RecipeTypes.RECYCLABLE::matches).filter(recipe -> recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).is(item)).map(recipe -> recipe.getIngredients().stream().map(RecyclingManager::getInverse).reduce(RecyclingOutputs::addOther).map(outputs -> outputs.multiplyAll(1.0f / (float)recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getCount()))).dropWhile(Optional::isEmpty).map(Optional::get).distinct().toList();
        if (possibleOutputs.size() == 1) {
            return possibleOutputs.get(0);
        }
        return RecyclingOutputs.empty();
    }

    public static final RecyclingOutputs getRawRecyclingOutputs(Level level, ItemStack stack) {
        Optional<RecyclingOutputs> optional = level.getRecipeManager().getRecipeFor((RecipeType)PetrolparkRecipeTypes.RECYCLING.get(), (RecipeInput)new SingleRecipeInput(stack), level).map(RecipeHolder::value).map(IRecyclingRecipe::outputs);
        if (optional.isPresent()) {
            return optional.get().copy();
        }
        return Optional.ofNullable(ITEM_RECYCLINGS.computeIfAbsent(stack.getItem(), item -> RecyclingManager.getInverseRecipeRecyclingOutputs(level, item)).copy()).orElse(RecyclingOutputs.empty());
    }

    public static final RecyclingOutputs getRecyclingOutputs(Level level, ItemStack stack) {
        ItemStack copy = stack.copyWithCount(1);
        RecyclingOutputs outputs = RecyclingManager.getRawRecyclingOutputs(level, copy).multiplyAll(stack.getCount());
        for (RecyclingOutputsModifier modifier : OUTPUT_MODIFIERS) {
            modifier.modify(level, copy, outputs);
        }
        return outputs;
    }

    @SubscribeEvent
    public static final void onRecipesUpdated(RecipesUpdatedEvent event) {
        INGREDIENT_INVERSES.clear();
        ITEM_RECYCLINGS.clear();
        RecyclingManager.loadIngredientInverses(event.getRecipeManager());
    }

    static {
        RecyclingManager.registerModifier(RecyclingOutputsModifier.DURABILITY);
        RecyclingManager.registerModifier(RecyclingOutputsModifier.CONTAMINANTS);
        RecyclingManager.registerModifier(RecyclingOutputsModifier.DECOMPRESSION);
    }
}

