/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.shop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.core.shop.Shop;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ShopsData
extends HashMap<Holder<Shop>, TeamShop> {
    public static final Codec<ShopsData> CODEC = Codec.unboundedMap(Shop.CODEC, TeamShop.CODEC).xmap(ShopsData::fromMap, Function.identity());
    public static final StreamCodec<RegistryFriendlyByteBuf, ShopsData> STREAM_CODEC = ByteBufCodecs.map(ShopsData::new, Shop.STREAM_CODEC, TeamShop.STREAM_CODEC);

    public static ShopsData fromMap(Map<Holder<Shop>, TeamShop> map) {
        ShopsData teamShops = new ShopsData(map.size());
        teamShops.putAll(map);
        return teamShops;
    }

    public ShopsData() {
        this(0);
    }

    public ShopsData(int size) {
        super(size);
    }

    public TeamShop getOrCreate(Holder<Shop> shop) {
        return this.computeIfAbsent(shop, s -> this.defaultEntry());
    }

    public void grantXP(Holder<Shop> shop, int amount) {
        this.getOrCreate(shop).xp += amount;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getName(Holder<Shop> shop) {
        return (Component)this.getOrCreate(shop).getCustomName().map(Component::literal).orElse(((Shop)shop.value()).getName().copy());
    }

    protected TeamShop defaultEntry() {
        return new TeamShop(0, Optional.empty());
    }

    protected static class TeamShop {
        public static final Codec<TeamShop> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("xp").forGetter(TeamShop::getXp), (App)Codec.STRING.optionalFieldOf("customName").forGetter(TeamShop::getCustomName)).apply((Applicative)instance, TeamShop::new));
        public static final StreamCodec<FriendlyByteBuf, TeamShop> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, TeamShop::getXp, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), TeamShop::getCustomName, TeamShop::new);
        public int xp;
        public Optional<String> customName;

        public TeamShop(int xp, Optional<String> customName) {
            this.customName = customName;
            this.xp = xp;
        }

        public int getXp() {
            return this.xp;
        }

        public Optional<String> getCustomName() {
            return this.customName;
        }
    }
}

