/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.shop.offer.order;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.ItemAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.PassAdvancedIngredient;
import com.petrolpark.util.Lang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class ShopOrderModifier
implements LootContextUser {
    public static final Codec<ShopOrderModifier> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)ItemAdvancedIngredient.CODEC.optionalFieldOf("requirement", (Object)PassAdvancedIngredient.INSTANCE).forGetter(ShopOrderModifier::getAdvancedIngredient), (App)NumberProviders.CODEC.fieldOf("success").forGetter(ShopOrderModifier::getSuccessMultiplier), (App)NumberProviders.CODEC.optionalFieldOf("failure", (Object)ConstantValue.exactly((float)0.0f)).forGetter(ShopOrderModifier::getFailureNumberProvider)).apply((Applicative)instance, ShopOrderModifier::new)));
    public final IAdvancedIngredient<? super ItemStack> ingredient;
    public final NumberProvider successMultiplier;
    public final NumberProvider failureMultiplier;

    public ShopOrderModifier(IAdvancedIngredient<? super ItemStack> ingredient, NumberProvider successMultiplier, NumberProvider failureMultiplier) {
        this.ingredient = ingredient;
        this.successMultiplier = successMultiplier;
        this.failureMultiplier = failureMultiplier;
    }

    public IAdvancedIngredient<? super ItemStack> getAdvancedIngredient() {
        return this.ingredient;
    }

    public NumberProvider getSuccessMultiplier() {
        return this.successMultiplier;
    }

    public NumberProvider getFailureNumberProvider() {
        return this.failureMultiplier;
    }

    public List<Component> getDescription(Level level) {
        ArrayList<Component> description = new ArrayList<Component>();
        this.ingredient.addToDescription(new Lang.IndentedTooltipBuilder(description));
        return description;
    }

    public NumberProvider getMultiplier(ItemStack stack, Level level) {
        if (this.ingredient.test(stack)) {
            return this.successMultiplier;
        }
        return this.failureMultiplier;
    }
}

