/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.team;

import com.google.common.collect.ImmutableList;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.core.team.scoreboard.ScoreboardTeam;
import com.petrolpark.core.team.singleplayer.SinglePlayerTeam;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class GatherTeamProvidersEvent
extends PlayerEvent {
    protected final List<ITeam.Provider> teamProviders = new ArrayList<ITeam.Provider>(2);

    public GatherTeamProvidersEvent(Player player) {
        super(player);
        this.add(SinglePlayerTeam.provider(player));
        PlayerTeam team = player.getTeam();
        if (team != null) {
            this.add(ScoreboardTeam.provider(team));
        }
    }

    public List<ITeam.Provider> getTeamProvidersUnmodifiable() {
        return ImmutableList.copyOf(this.teamProviders);
    }

    public List<ITeam> getTeamsUnmodifiable(Level level) {
        return this.teamProviders.stream().map(provider -> provider.provideTeam(level)).toList();
    }

    public boolean add(ITeam.Provider teamProvider) {
        return this.teamProviders.add(teamProvider);
    }

    public boolean remove(ITeam.Provider teamProvider) {
        return this.teamProviders.remove(teamProvider);
    }
}

