/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.team;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.PetrolparkTeamProviderTypes;
import com.petrolpark.core.team.GatherTeamProvidersEvent;
import com.petrolpark.core.team.NoTeam;
import com.petrolpark.util.Lang;
import java.util.stream.Stream;
import net.createmod.catnip.net.base.ClientboundPacketPayload;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.common.NeoForge;

public interface ITeam
extends MutableDataComponentHolder {
    public static Stream<ITeam> streamAll(Player player) {
        GatherTeamProvidersEvent event = new GatherTeamProvidersEvent(player);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getTeamProvidersUnmodifiable().stream().map(provider -> provider.provideTeam(player.level()));
    }

    public Provider getProvider();

    default public boolean isNone() {
        return this.getProvider().getProviderType() == PetrolparkTeamProviderTypes.NONE.get();
    }

    public boolean isMember(Player var1);

    public int memberCount();

    public Stream<String> streamMemberUsernames();

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public Stream<Player> streamMembers();

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    default public Stream<ServerPlayer> streamServerMembers() {
        return this.streamMembers().map(p -> {
            ServerPlayer sp;
            return p instanceof ServerPlayer ? (sp = (ServerPlayer)p) : null;
        });
    }

    public boolean isAdmin(Player var1);

    public Component getName();

    @OnlyIn(value=Dist.CLIENT)
    public void renderIcon(GuiGraphics var1);

    @OnlyIn(value=Dist.CLIENT)
    default public Component getRenderedMemberList(int maxTextWidth) {
        Minecraft mc = Minecraft.getInstance();
        return Lang.shortList(this.streamMemberUsernames().map(Component::literal).toList(), maxTextWidth, mc.font);
    }

    default public void sendToAllMembers(ClientboundPacketPayload packet) {
        this.streamServerMembers().forEach(player -> CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)packet));
    }

    public static interface Provider {
        public static final Codec<Provider> TYPED_CODEC = PetrolparkRegistries.TEAM_PROVIDER_TYPES.byNameCodec().dispatch(Provider::getProviderType, ProviderType::codec);
        public static final Codec<Provider> CODEC = Codec.lazyInitialized(() -> Codec.withAlternative(TYPED_CODEC, (Codec)Codec.unit((Object)NoTeam.INSTANCE)));
        public static final StreamCodec<RegistryFriendlyByteBuf, Provider> STREAM_CODEC = ByteBufCodecs.registry(PetrolparkRegistries.Keys.TEAM_PROVIDER_TYPE).dispatch(Provider::getProviderType, ProviderType::streamCodec);

        public ITeam provideTeam(Level var1);

        public ProviderType getProviderType();
    }

    public record ProviderType(MapCodec<? extends Provider> codec, StreamCodec<? super RegistryFriendlyByteBuf, ? extends Provider> streamCodec) {
    }
}

