/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.team;

import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.client.rendering.PetrolparkGuiTexture;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.core.team.packet.BindTeamPacket;
import java.util.List;
import javax.annotation.Nonnull;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SelectTeamScreen
extends AbstractSimiScreen {
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/stonecutter/scroller_disabled");
    public final BindTeamPacket.Factory packetFactory;
    protected final List<ITeam> selectableTeams;
    protected ITeam selectedTeam = null;
    private float scrollOffset = 0.0f;
    private boolean scrolling = false;
    private int startIndex = 0;
    private PetrolparkGuiTexture background;
    protected static final int SELECTION_AREA_X = 8;
    protected static final int SELECTION_AREA_Y = 15;
    protected static final int SELECTION_AREA_WIDTH = 145;
    protected static final int TEAM_BUTTON_HEIGHT = 35;
    protected static final int SCROLL_AREA_X = 156;
    protected static final int SCROLL_AREA_HEIGHT = 140;

    public SelectTeamScreen(Component title, List<ITeam> selectableTeams, BindTeamPacket.Factory packetFactory) {
        super(title);
        this.selectableTeams = selectableTeams;
        this.packetFactory = packetFactory;
        this.background = PetrolparkGuiTexture.SELECT_TEAM_BACKGROUND;
    }

    public ITeam getSelectedTeam() {
        return this.selectedTeam;
    }

    public void sendTeamSelection() {
        if (this.getSelectedTeam() != null) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)this.packetFactory.create(this.getSelectedTeam().getProvider()));
        }
    }

    protected void init() {
        this.setWindowSize(this.background.width, this.background.height);
        super.init();
    }

    protected void renderWindow(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        graphics.drawString(this.font, this.title, x + (this.background.getWidth() - this.font.width((FormattedText)this.title)) / 2, y + 5, 0x333333, false);
        int k = (int)(129.0f * this.scrollOffset);
        ResourceLocation scrollerRL = this.isScrollBarActive() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
        graphics.blitSprite(scrollerRL, x + 156, y + 15 + k, 12, 15);
        x = this.guiLeft + 8;
        y = this.guiTop + 15;
        for (int index = this.startIndex; index < this.startIndex + 4; ++index) {
            int visibleIndex = index - this.startIndex;
            if (index >= this.selectableTeams.size()) break;
            ITeam team = this.selectableTeams.get(index);
            PetrolparkGuiTexture texture = team == this.selectedTeam ? PetrolparkGuiTexture.SELECT_TEAM_SELECTED : PetrolparkGuiTexture.SELECT_TEAM;
            double relMouseX = (double)mouseX - (double)x;
            double relMouseY = (double)mouseY - ((double)y + (double)visibleIndex * 35.0);
            if (relMouseX >= 0.0 && relMouseY >= 0.0 && relMouseX < 145.0 && relMouseY < 35.0) {
                texture = PetrolparkGuiTexture.SELECT_TEAM_HIGHLIGHTED;
            }
            texture.render(graphics, x, y + visibleIndex * 35);
            PoseStack ms = graphics.pose();
            ms.pushPose();
            ms.translate((float)(x + 4), (float)(y + 4 + visibleIndex * 35), 0.0f);
            ms.pushPose();
            ms.scale(1.7f, 1.7f, 1.0f);
            team.renderIcon(graphics);
            ms.popPose();
            ms.translate(32.0f, 3.0f, 0.0f);
            Minecraft mc = this.minecraft;
            if (mc != null) {
                graphics.drawString(mc.font, team.getName(), 0, 0, 0xFFFFFF);
                graphics.drawString(mc.font, (Component)team.getRenderedMemberList(100).copy().withStyle(ChatFormatting.GRAY), 0, 12, 0xFFFFFF);
            }
            ms.popPose();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        int x = this.guiLeft + 8;
        int y = this.guiTop + 15;
        int maxIndex = this.startIndex + 4;
        for (int index = this.startIndex; index < maxIndex; ++index) {
            int visibleIndex = index - this.startIndex;
            double relMouseX = mouseX - (double)x;
            double relMouseY = mouseY - ((double)y + (double)visibleIndex * 35.0);
            if (!(relMouseX >= 0.0) || !(relMouseY >= 0.0) || !(relMouseX < 145.0) || !(relMouseY < 35.0) || index < 0 || index >= this.selectableTeams.size()) continue;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f));
            this.selectedTeam = this.selectableTeams.get(index);
            return true;
        }
        x = this.guiLeft + 156;
        y = this.guiTop + 9;
        if (mouseX >= (double)x && mouseX < (double)(x + 12) && mouseY >= (double)y && mouseY < (double)(y + 140)) {
            this.scrolling = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int top = this.guiTop + 15;
            int bottom = top + 140;
            this.scrollOffset = ((float)mouseY - (float)top - 7.5f) / ((float)(bottom - top) - 15.0f);
            this.scrollOffset = Mth.clamp((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)scrollY / (float)i;
            this.scrollOffset = Mth.clamp((float)(this.scrollOffset - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)i) + 0.5);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.selectableTeams.size() > 4;
    }

    protected int getOffscreenRows() {
        return this.selectableTeams.size() - 4;
    }

    public void onClose() {
        super.onClose();
        this.sendTeamSelection();
    }
}

