/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.petrolpark.core.item.decay.ageing.AgeingContainerWrapper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ChestMenu.class})
public abstract class ChestMenuMixin
extends AbstractContainerMenu {
    protected ChestMenuMixin(MenuType<?> menuType, int containerId) {
        super(menuType, containerId);
        throw new AssertionError();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WrapOperation(method={"Lnet/minecraft/world/inventory/ChestMenu;quickMoveStack(Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/Slot;getItem()Lnet/minecraft/world/item/ItemStack;")})
    public ItemStack wrapGetItem(Slot instance, Operation<ItemStack> original) {
        Level level;
        Container container = instance.container;
        if (container instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)container;
            level = barrel.getLevel();
            return AgeingContainerWrapper.withAgeingDecayRemoved(level, (ItemStack)original.call(new Object[]{instance}));
        } else {
            container = instance.container;
            if (!(container instanceof AgeingContainerWrapper)) return (ItemStack)original.call(new Object[]{instance});
            AgeingContainerWrapper ageingContainer = (AgeingContainerWrapper)container;
            if (!AgeingContainerWrapper.ageingInVanillaBarrelsEnabled()) return (ItemStack)original.call(new Object[]{instance});
            level = ageingContainer.getLevel();
        }
        return AgeingContainerWrapper.withAgeingDecayRemoved(level, (ItemStack)original.call(new Object[]{instance}));
    }
}

