/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.petrolpark.PetrolparkMobEffects;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.extensions.ILivingEntityExtension;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ILivingEntityExtension {
    @Shadow
    private DamageSource lastDamageSource;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
        throw new AssertionError();
    }

    @WrapWithCondition(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/WalkAnimationState;setSpeed(F)V")})
    protected boolean wrapSetSpeedServer(WalkAnimationState walkAnimation, float speed) {
        return !this.self().hasEffect(PetrolparkMobEffects.NUMBNESS.getDelegate());
    }

    @WrapMethod(method={"setLastHurtByMob"})
    public void wrapSetLastHurtByMob(LivingEntity livingEntity, Operation<Void> original) {
        if (!this.self().hasEffect(PetrolparkMobEffects.NUMBNESS.getDelegate()) || livingEntity == null) {
            original.call(new Object[]{livingEntity});
        }
    }

    @WrapMethod(method={"playHurtSound"})
    protected void wrapPlayHurtSound(DamageSource source, Operation<Void> original) {
        if (!this.self().hasEffect(PetrolparkMobEffects.NUMBNESS.getDelegate())) {
            original.call(new Object[]{source});
        }
    }

    @WrapMethod(method={"getLastDamageSource"})
    protected DamageSource wrapGetLastDamageSource(Operation<DamageSource> original) {
        if (this.self().hasEffect(PetrolparkMobEffects.NUMBNESS.getDelegate())) {
            this.lastDamageSource = null;
        }
        return (DamageSource)original.call(new Object[0]);
    }

    @WrapWithCondition(method={"handleDamageEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/WalkAnimationState;setSpeed(F)V")})
    protected boolean wrapSetSpeedClient(WalkAnimationState walkAnimation, float speed) {
        return !this.self().hasEffect(PetrolparkMobEffects.NUMBNESS.getDelegate());
    }

    @WrapWithCondition(method={"handleDamageEvent"}, at={@At(value="INVOKE", target="playSound")})
    protected boolean wrapPlaySound(LivingEntity livingEntity, SoundEvent soundEvent, float pitch, float volume) {
        return !this.self().hasEffect(PetrolparkMobEffects.NUMBNESS.getDelegate());
    }
}

