/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.PetrolparkClient;
import com.petrolpark.client.creativemodetab.CustomTab;
import com.petrolpark.core.extendedinventory.ExtendedInventory;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeModeInventoryScreenMixin
extends EffectRenderingInventoryScreen<CreativeModeInventoryScreen.ItemPickerMenu> {
    @Shadow
    private Slot destroyItemSlot;

    public CreativeModeInventoryScreenMixin(CreativeModeInventoryScreen.ItemPickerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        throw new AssertionError();
    }

    @Inject(method={"Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="RETURN")})
    public void inRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        CreativeModeTab creativeModeTab = CreativeModeInventoryScreenMixin.getSelectedTab();
        if (creativeModeTab instanceof CustomTab) {
            CustomTab tab = (CustomTab)creativeModeTab;
            int offset = ((CreativeModeInventoryScreen.ItemPickerMenu)this.getMenu()).getRowIndexForScroll(this.getScrollOffs());
            PoseStack ms = graphics.pose();
            ms.pushPose();
            ms.translate((float)this.getGuiLeft() + 8.0f, (float)this.getGuiTop() + 17.0f, 0.0f);
            for (int y = 0; y < 5; ++y) {
                for (int x = 0; x < 9; ++x) {
                    CustomTab.ITabEntry entry = tab.renderedEntries.get(9 * (y + offset) + x);
                    if (entry == null) continue;
                    ms.pushPose();
                    ms.translate((float)x * 18.0f, (float)y * 18.0f, 0.0f);
                    entry.render(graphics, mouseX, mouseY, partialTick);
                    ms.popPose();
                }
            }
            ms.popPose();
        }
    }

    @WrapOperation(method={"selectTab"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/NonNullList;size()I")})
    public int wrapSlotListSize(NonNullList<Slot> slots, Operation<Integer> original) {
        return 46;
    }

    @Inject(method={"Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen;selectTab(Lnet/minecraft/world/item/CreativeModeTab;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen;destroyItemSlot:Lnet/minecraft/world/inventory/Slot;", ordinal=0)})
    public void inSelectTab(CreativeModeTab tab, CallbackInfo ci) {
        Minecraft mc = this.getMinecraft();
        if (mc == null) {
            return;
        }
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        Optional<ExtendedInventory> invOp = ExtendedInventory.get((Player)player);
        if (invOp.isEmpty()) {
            return;
        }
        ExtendedInventory inv = invOp.get();
        Int2ObjectArrayMap extendedInventorySlots = new Int2ObjectArrayMap();
        for (Slot slot : player.inventoryMenu.slots) {
            if (slot.getSlotIndex() < inv.getExtraInventoryStartSlotIndex()) continue;
            extendedInventorySlots.put(slot.getSlotIndex(), (Object)slot);
        }
        PetrolparkClient.EXTENDED_INVENTORY_HANDLER.currentScreen = this;
        PetrolparkClient.EXTENDED_INVENTORY_HANDLER.refreshExtraInventoryAreas(inv);
        PetrolparkClient.EXTENDED_INVENTORY_HANDLER.addSlotsToClientMenu(inv, arg_0 -> ((CreativeModeInventoryScreen.ItemPickerMenu)((CreativeModeInventoryScreen.ItemPickerMenu)this.menu)).addSlot(arg_0), (arg_0, arg_1, arg_2, arg_3) -> CreativeModeInventoryScreenMixin.lambda$inSelectTab$0((Int2ObjectMap)extendedInventorySlots, arg_0, arg_1, arg_2, arg_3));
    }

    @Inject(method={"Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen;slotClicked"}, at={@At(value="HEAD")})
    protected void inSlotClicked(@Nullable Slot slot, int slotId, int mouseButton, ClickType type, CallbackInfo ci) {
        Minecraft mc = this.getMinecraft();
        if (mc == null) {
            return;
        }
        LocalPlayer player = mc.player;
        MultiPlayerGameMode gameMode = mc.gameMode;
        if (player == null || gameMode == null) {
            return;
        }
        Optional<ExtendedInventory> invOp = ExtendedInventory.get((Player)player);
        if (invOp.isPresent() && slot == this.destroyItemSlot && type == ClickType.QUICK_MOVE) {
            ExtendedInventory inv = invOp.get();
            for (Slot inventorySlot : ((CreativeModeInventoryScreen.ItemPickerMenu)this.menu).slots) {
                if (inventorySlot.getSlotIndex() < inv.getExtraInventoryStartSlotIndex()) continue;
                gameMode.handleCreativeModeItemAdd(ItemStack.EMPTY, inventorySlot.index);
            }
        }
    }

    @Accessor(value="selectedTab")
    public static CreativeModeTab getSelectedTab() {
        throw new AssertionError();
    }

    @Accessor(value="scrollOffs")
    public abstract float getScrollOffs();

    private static /* synthetic */ Slot lambda$inSelectTab$0(Int2ObjectMap extendedInventorySlots, Container c, int i, int x, int y) {
        return new CreativeModeInventoryScreen.SlotWrapper((Slot)extendedInventorySlots.get(i), i, x, y);
    }
}

